/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.type.ArenaTargetType;
import su.nightexpress.ama.arena.script.action.Parameter;

public class Parameters {
    private static final Map<String, Parameter<?>> REGISTRY = new HashMap();
    public static final Parameter<String> WAVE = Parameters.asString("wave");
    public static final Parameter<String> SPAWNERS = Parameters.asString("spawners");
    public static final Parameter<String> REGION = Parameters.asString("region");
    public static final Parameter<String> SHOP_CATEGORY = Parameters.asString("shop_category");
    public static final Parameter<String> SHOP_PRODUCT = Parameters.asString("shop_product");
    public static final Parameter<String> REWARD = Parameters.asString("reward");
    public static final Parameter<String> SPOT = Parameters.asString("spot");
    public static final Parameter<String> STATE = Parameters.asString("state");
    public static final Parameter<String> NAME = Parameters.asString("name");
    public static final Parameter<String> MESSAGE = Parameters.asString("message");
    public static final Parameter<ArenaTargetType> TARGET = Parameters.register("target", string -> StringUtil.getEnum((String)string, ArenaTargetType.class).orElse(ArenaTargetType.GLOBAL));
    public static final Parameter<Integer> AMOUNT = Parameters.asInt("amount");

    @NotNull
    public static Optional<Parameter<?>> getByName(@NotNull String string) {
        return Optional.ofNullable(REGISTRY.get(string.toLowerCase()));
    }

    @NotNull
    public static Collection<Parameter<?>> getParameters() {
        return REGISTRY.values();
    }

    @NotNull
    public static <V> Parameter<V> register(@NotNull String string, @NotNull Function<String, V> function) {
        Parameter<V> parameter = new Parameter<V>(string, function);
        REGISTRY.put(parameter.getName(), parameter);
        return parameter;
    }

    @NotNull
    public static Parameter<Integer> asInt(@NotNull String string2) {
        Function<String, Integer> function = string -> StringUtil.getInteger((String)string, (int)0);
        return Parameters.register(string2, function);
    }

    @NotNull
    public static Parameter<String> asString(@NotNull String string) {
        Function<String, String> function = Colorizer::strip;
        return Parameters.register(string, function);
    }
}

