/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.utils.Colorizer;
import su.nightexpress.ama.api.arena.type.ArenaTargetType;
import su.nightexpress.ama.api.event.ArenaGameGenericEvent;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.impl.ArenaUpcomingWave;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.script.action.Parameter;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.Parameters;
import su.nightexpress.ama.arena.script.action.ScriptAction;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;
import su.nightexpress.ama.arena.shop.impl.ShopProduct;
import su.nightexpress.ama.arena.spot.ArenaSpot;
import su.nightexpress.ama.arena.supply.ArenaSupplyChest;
import su.nightexpress.ama.arena.wave.ArenaWave;
import su.nightexpress.ama.arena.wave.ArenaWaveMob;

public class ScriptActions {
    private static final Map<String, ScriptAction> REGISTRY = new HashMap<String, ScriptAction>();
    public static final ScriptAction UNLOCK_REGION = ScriptActions.register("unlock_region", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.REGION, "");
        ArenaRegion arenaRegion = arenaGameGenericEvent.getArena().getConfig().getRegionManager().getRegion(string);
        if (arenaRegion != null) {
            arenaRegion.unlock();
        }
    }, Parameters.REGION);
    public static final ScriptAction LOCK_REGION = ScriptActions.register("lock_region", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.REGION, "");
        ArenaRegion arenaRegion = arenaGameGenericEvent.getArena().getConfig().getRegionManager().getRegion(string);
        if (arenaRegion != null) {
            arenaRegion.lock();
        }
    }, Parameters.REGION);
    public static final ScriptAction UNLOCK_SHOP = ScriptActions.register("unlock_shop", (arenaGameGenericEvent, parameterResult) -> arenaGameGenericEvent.getArena().getConfig().getShopManager().unlock(), new Parameter[0]);
    public static final ScriptAction LOCK_SHOP = ScriptActions.register("lock_shop", (arenaGameGenericEvent, parameterResult) -> arenaGameGenericEvent.getArena().getConfig().getShopManager().lock(), new Parameter[0]);
    public static final ScriptAction UNLOCK_SHOP_CATEGORY = ScriptActions.register("unlock_shop_category", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.SHOP_CATEGORY, "");
        ShopCategory shopCategory = arenaGameGenericEvent.getArena().getConfig().getShopManager().getCategory(string);
        if (shopCategory != null) {
            shopCategory.unlock();
        }
    }, Parameters.SHOP_CATEGORY);
    public static final ScriptAction LOCK_SHOP_CATEGORY = ScriptActions.register("lock_shop_category", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.SHOP_CATEGORY, "");
        ShopCategory shopCategory = arenaGameGenericEvent.getArena().getConfig().getShopManager().getCategory(string);
        if (shopCategory != null) {
            shopCategory.lock();
        }
    }, Parameters.SHOP_CATEGORY);
    public static final ScriptAction UNLOCK_SHOP_PRODUCT = ScriptActions.register("unlock_shop_product", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.SHOP_CATEGORY, "");
        String string2 = parameterResult.get(Parameters.SHOP_PRODUCT, "");
        ShopCategory shopCategory = arenaGameGenericEvent.getArena().getConfig().getShopManager().getCategory(string);
        if (shopCategory == null) {
            return;
        }
        ShopProduct shopProduct = shopCategory.getProduct(string2);
        if (shopProduct != null) {
            shopProduct.unlock();
        }
    }, Parameters.SHOP_CATEGORY, Parameters.SHOP_PRODUCT);
    public static final ScriptAction LOCK_SHOP_PRODUCT = ScriptActions.register("lock_shop_product", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.SHOP_CATEGORY, "");
        String string2 = parameterResult.get(Parameters.SHOP_PRODUCT, "");
        ShopCategory shopCategory = arenaGameGenericEvent.getArena().getConfig().getShopManager().getCategory(string);
        if (shopCategory == null) {
            return;
        }
        ShopProduct shopProduct = shopCategory.getProduct(string2);
        if (shopProduct != null) {
            shopProduct.lock();
        }
    }, Parameters.SHOP_CATEGORY, Parameters.SHOP_PRODUCT);
    public static final ScriptAction GIVE_REWARD = ScriptActions.register("give_reward", (arenaGameGenericEvent, parameterResult) -> {
        ArenaTargetType arenaTargetType = parameterResult.get(Parameters.TARGET, ArenaTargetType.GLOBAL);
        String string = parameterResult.get(Parameters.REWARD, "");
        arenaGameGenericEvent.getArena().getConfig().getRewardManager().getReward(string).ifPresent(arenaReward -> arenaReward.give(arenaGameGenericEvent.getArena(), arenaTargetType));
    }, Parameters.REWARD, Parameters.TARGET);
    public static final ScriptAction RUN_COMMAND = ScriptActions.register("run_command", (arenaGameGenericEvent, parameterResult) -> {
        ArenaTargetType arenaTargetType = parameterResult.get(Parameters.TARGET, ArenaTargetType.GLOBAL);
        String string = parameterResult.get(Parameters.NAME, "");
        arenaGameGenericEvent.getArena().runCommand(string, arenaTargetType);
    }, Parameters.NAME, Parameters.TARGET);
    public static final ScriptAction BROADCAST = ScriptActions.register("broadcast", (arenaGameGenericEvent, parameterResult) -> {
        ArenaTargetType arenaTargetType = parameterResult.get(Parameters.TARGET, ArenaTargetType.GLOBAL);
        String string = Colorizer.apply((String)parameterResult.get(Parameters.MESSAGE, ""));
        arenaGameGenericEvent.getArena().broadcast(arenaTargetType, string);
    }, Parameters.MESSAGE, Parameters.TARGET);
    public static final ScriptAction CHANGE_SPOT = ScriptActions.register("change_spot", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.SPOT, "");
        String string2 = parameterResult.get(Parameters.STATE, "");
        ArenaSpot arenaSpot = arenaGameGenericEvent.getArena().getConfig().getSpotManager().getSpot(string);
        if (arenaSpot != null) {
            arenaSpot.setState(arenaGameGenericEvent.getArena(), string2);
        }
    }, Parameters.SPOT, Parameters.STATE);
    public static final ScriptAction REFILL_SUPPLY_CHEST = ScriptActions.register("refill_supply_chest", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.NAME, "");
        ArenaSupplyChest arenaSupplyChest = arenaGameGenericEvent.getArena().getConfig().getSupplyManager().getChest(string);
        if (arenaSupplyChest != null) {
            arenaSupplyChest.refill();
        }
    }, Parameters.NAME);
    public static final ScriptAction ADJUST_MOB_AMOUNT = ScriptActions.register("adjust_mob_amount", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.WAVE, "");
        int n = parameterResult.get(Parameters.AMOUNT, 0);
        arenaGameGenericEvent.getArena().addWaveAmplificatorAmount(string, n);
    }, Parameters.WAVE, Parameters.AMOUNT);
    public static final ScriptAction ADJUST_MOB_LEVEL = ScriptActions.register("adjust_mob_level", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.WAVE, "");
        int n = parameterResult.get(Parameters.AMOUNT, 0);
        arenaGameGenericEvent.getArena().addWaveAmplificatorLevel(string, n);
    }, Parameters.WAVE, Parameters.AMOUNT);
    public static final ScriptAction INJECT_WAVE = ScriptActions.register("inject_wave", (arenaGameGenericEvent, parameterResult) -> {
        String string = parameterResult.get(Parameters.REGION, "");
        String string2 = parameterResult.get(Parameters.WAVE, "");
        String string3 = parameterResult.get(Parameters.SPAWNERS, "");
        Arena arena = arenaGameGenericEvent.getArena();
        ArenaConfig arenaConfig = arena.getConfig();
        ArenaRegion arenaRegion = arenaConfig.getRegionManager().getRegion(string);
        if (arenaRegion == null) {
            return;
        }
        ArenaWave arenaWave = arenaConfig.getWaveManager().getWave(string2);
        if (arenaWave == null) {
            return;
        }
        ArrayList<ArenaWaveMob> arrayList = new ArrayList<ArenaWaveMob>(arenaWave.getMobsByChance().stream().map(ArenaWaveMob::new).toList());
        arrayList.forEach(arenaWaveMob -> arenaWaveMob.setAmount((int)((double)arenaWaveMob.getAmount() + arena.getWaveAmplificatorAmount(arenaWave.getId()))));
        arrayList.forEach(arenaWaveMob -> arenaWaveMob.setLevel((int)((double)arenaWaveMob.getLevel() + arena.getWaveAmplificatorLevel(arenaWave.getId()))));
        arrayList.removeIf(arenaWaveMob -> arenaWaveMob.getAmount() <= 0);
        if (arrayList.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(string3.split(",")));
        arrayList2.removeIf(String::isEmpty);
        arena.injectWave(new ArenaUpcomingWave(arenaRegion, arrayList, arrayList2));
    }, Parameters.WAVE, Parameters.REGION, Parameters.SPAWNERS);

    @NotNull
    public static ScriptAction register(@NotNull String string, @NotNull BiConsumer<ArenaGameGenericEvent, ParameterResult> biConsumer, Parameter<?> ... parameterArray) {
        return ScriptActions.register(new ScriptAction(string, biConsumer, parameterArray));
    }

    @NotNull
    public static ScriptAction register(@NotNull ScriptAction scriptAction) {
        REGISTRY.put(scriptAction.getName(), scriptAction);
        return scriptAction;
    }

    @Nullable
    public static ScriptAction getByName(@NotNull String string) {
        return REGISTRY.get(string.toLowerCase());
    }

    @NotNull
    public static Set<ScriptAction> getActions() {
        return new HashSet<ScriptAction>(REGISTRY.values());
    }
}

