/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.action;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.utils.regex.RegexUtil;
import su.nightexpress.ama.arena.script.action.Parameter;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.ScriptAction;
import su.nightexpress.ama.arena.script.action.ScriptActions;

public class ScriptPreparedAction {
    private static final String PATTERN_PARAMETER = ":(?:'|\")(.*?)(?:'|\")(?=>|\\s|$)";
    private final ScriptAction action;
    private final ParameterResult parameterResult;

    public ScriptPreparedAction(@NotNull ScriptAction scriptAction, @NotNull ParameterResult parameterResult) {
        this.action = scriptAction;
        this.parameterResult = parameterResult;
    }

    @Nullable
    public static ScriptPreparedAction parse(@NotNull String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length == 0) {
            return null;
        }
        ScriptAction scriptAction = ScriptActions.getByName(stringArray[0].replace("[", "").replace("]", ""));
        if (scriptAction == null) {
            return null;
        }
        String string2 = Stream.of(stringArray).skip(1L).collect(Collectors.joining(" "));
        ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(scriptAction, new ParameterResult());
        scriptAction.getParameters().forEach(parameter -> {
            Pattern pattern = Pattern.compile(parameter.getName() + PATTERN_PARAMETER);
            Matcher matcher = RegexUtil.getMatcher((Pattern)pattern, (String)string2);
            if (RegexUtil.matcherFind((Matcher)matcher)) {
                String string2 = matcher.group(1);
                scriptPreparedAction.getParameters().add(parameter, parameter.getParser().apply(string2));
            }
        });
        return scriptPreparedAction;
    }

    @NotNull
    public String toRaw() {
        String string = "[" + this.getAction().getName() + "] ";
        String string2 = this.getParameters().getParams().entrySet().stream().map(entry -> ((Parameter)entry.getKey()).getName() + ":\"" + entry.getValue() + "\"").collect(Collectors.joining(" "));
        return string + string2;
    }

    public ScriptAction getAction() {
        return this.action;
    }

    public ParameterResult getParameters() {
        return this.parameterResult;
    }
}

