/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.condition;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.ama.arena.script.condition.ScriptCondition;
import su.nightexpress.ama.arena.script.condition.ScriptConditions;

public class ScriptPreparedCondition {
    private final ScriptCondition<?, ?> condition;
    private final Object value;
    private final ScriptCondition.Operator operator;

    public ScriptPreparedCondition(@NotNull ScriptCondition<?, ?> scriptCondition, @NotNull Object object, @NotNull ScriptCondition.Operator operator) {
        this.condition = scriptCondition;
        this.value = object;
        this.operator = operator;
    }

    @Nullable
    public static ScriptPreparedCondition parse(@NotNull String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 3) {
            return null;
        }
        ScriptCondition<?, ?> scriptCondition = ScriptConditions.getByName(stringArray[0].replace("[", "").replace("]", ""));
        if (scriptCondition == null) {
            return null;
        }
        Object obj = scriptCondition.getParser().apply(stringArray[2]);
        if (obj == null) {
            return null;
        }
        ScriptCondition.Operator operator = ScriptCondition.Operator.fromString(stringArray[1]).orElse(ScriptCondition.Operator.EQUAL);
        return new ScriptPreparedCondition(scriptCondition, obj, operator);
    }

    @NotNull
    public String toRaw() {
        String string;
        String string2 = "[" + this.getCondition().getName() + "]";
        String string3 = this.getOperator().getRaw();
        Object object = this.getValue();
        if (object instanceof Number[]) {
            Number[] numberArray = (Number[])object;
            string = String.join((CharSequence)",", Arrays.stream(numberArray).map(String::valueOf).toList());
        } else {
            string = String.valueOf(this.getValue());
        }
        return string2 + " " + string3 + " " + string;
    }

    @NotNull
    public ScriptCondition<?, ?> getCondition() {
        return this.condition;
    }

    @NotNull
    public ScriptCondition.Operator getOperator() {
        return this.operator;
    }

    @NotNull
    public Object getValue() {
        return this.value;
    }
}

