/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.setup.manager;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.server.AbstractTask;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.setup.ArenaSetupUtils;
import su.nightexpress.ama.arena.setup.SetupItemType;
import su.nightexpress.ama.arena.setup.manager.AbstractSetupManager;
import su.nightexpress.ama.arena.spot.ArenaSpot;
import su.nightexpress.ama.arena.util.ArenaCuboid;
import su.nightexpress.ama.config.Lang;

public class SpotSetupManager
extends AbstractSetupManager<ArenaSpot> {
    private Location[] cuboidCache;
    private VisualTask visualTask;

    public SpotSetupManager(@NotNull AMA aMA) {
        super(aMA);
    }

    @Override
    protected void onSetupStart(@NotNull Player player, @NotNull ArenaSpot arenaSpot) {
        this.cuboidCache = new Location[2];
        arenaSpot.getCuboid().ifPresent(arenaCuboid -> {
            this.cuboidCache[0] = arenaCuboid.getMin().clone();
            this.cuboidCache[1] = arenaCuboid.getMax().clone();
        });
        this.visualTask = new VisualTask();
        this.visualTask.start();
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.setItem(0, SetupItemType.SPOT_CUBOID.getItem());
        playerInventory.setItem(8, SetupItemType.SPOT_SAVE.getItem());
    }

    @Override
    protected void onSetupEnd(@NotNull Player player, @NotNull ArenaSpot arenaSpot) {
        if (this.visualTask != null) {
            this.visualTask.stop();
            this.visualTask = null;
        }
        arenaSpot.getEditor().open(player, 1);
        this.cuboidCache = null;
    }

    @Override
    protected void handleItem(@NotNull PlayerInteractEvent playerInteractEvent, @NotNull Player player, @NotNull ArenaSpot arenaSpot, @NotNull ItemStack itemStack, @NotNull SetupItemType setupItemType) {
        switch (setupItemType) {
            case SPOT_CUBOID: {
                Block block = playerInteractEvent.getClickedBlock();
                if (block == null || block.isEmpty()) {
                    return;
                }
                Action action = playerInteractEvent.getAction();
                Location location = block.getLocation();
                ArenaSpot arenaSpot2 = arenaSpot.getArenaConfig().getSpotManager().getSpot(location);
                if (arenaSpot2 != null && !arenaSpot.getId().equals(arenaSpot2.getId())) {
                    ((AMA)this.plugin).getMessage(Lang.SETUP_SPOT_CUBOID_ERROR_OVERLAP).replace(arenaSpot2.replacePlaceholders()).send((CommandSender)player);
                    return;
                }
                int n = action == Action.LEFT_CLICK_BLOCK ? 0 : 1;
                this.cuboidCache[n] = location;
                ((AMA)this.plugin).getMessage(Lang.SETUP_SPOT_CUBOID_SET).replace(arenaSpot.replacePlaceholders()).replace("%corner%", (Object)(n + 1)).send((CommandSender)player);
                break;
            }
            case SPOT_SAVE: {
                if (this.cuboidCache[0] != null && this.cuboidCache[1] != null) {
                    ArenaCuboid arenaCuboid = new ArenaCuboid(this.cuboidCache[0], this.cuboidCache[1]);
                    arenaSpot.setCuboid(arenaCuboid);
                }
                arenaSpot.save();
                this.endSetup(player);
            }
        }
    }

    @Override
    protected void updateVisuals() {
        if (this.cuboidCache != null) {
            if (this.cuboidCache[0] != null) {
                ArenaSetupUtils.addVisualText(this.player, "&9\u00ab 1st Corner \u00bb", this.cuboidCache[0]);
                ArenaSetupUtils.addVisualBlock(this.player, this.cuboidCache[0]);
            }
            if (this.cuboidCache[1] != null) {
                ArenaSetupUtils.addVisualText(this.player, "&9\u00ab 2nd Corner \u00bb", this.cuboidCache[1]);
                ArenaSetupUtils.addVisualBlock(this.player, this.cuboidCache[1]);
            }
        }
    }

    private void updateVisualParticles(@NotNull Player player) {
        if (this.cuboidCache[0] != null && this.cuboidCache[1] != null) {
            new ArenaCuboid.Visualizer(this.cuboidCache[0], this.cuboidCache[1]).draw(player);
        }
    }

    @Override
    protected void removeVisuals() {
        ArenaSetupUtils.removeVisuals(this.player);
    }

    class VisualTask
    extends AbstractTask<AMA> {
        public VisualTask() {
            super((NexPlugin)((AMA)SpotSetupManager.this.plugin), 10L, true);
        }

        public void action() {
            if (SpotSetupManager.this.player == null) {
                return;
            }
            SpotSetupManager.this.updateVisualParticles(SpotSetupManager.this.player);
        }
    }
}

