/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.setup.manager;

import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.server.AbstractTask;
import su.nexmedia.engine.utils.LocationUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.editor.spot.SpotSettingsEditor;
import su.nightexpress.ama.arena.setup.ArenaSetupUtils;
import su.nightexpress.ama.arena.setup.SetupItemType;
import su.nightexpress.ama.arena.setup.manager.AbstractSetupManager;
import su.nightexpress.ama.arena.spot.ArenaSpot;
import su.nightexpress.ama.arena.spot.ArenaSpotState;
import su.nightexpress.ama.arena.util.ArenaCuboid;
import su.nightexpress.ama.config.Lang;

public class SpotStateSetupManager
extends AbstractSetupManager<ArenaSpotState> {
    private VisualTask visualTask;

    public SpotStateSetupManager(@NotNull AMA aMA) {
        super(aMA);
    }

    @Override
    protected void onSetupStart(@NotNull Player player, @NotNull ArenaSpotState arenaSpotState) {
        this.visualTask = new VisualTask();
        this.visualTask.start();
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.setItem(6, SetupItemType.SPOT_STATE_PREVIEW.getItem());
        playerInventory.setItem(7, SetupItemType.SPOT_SAVE.getItem());
        playerInventory.setItem(8, SetupItemType.SPOT_STATE_EXIT.getItem());
    }

    @Override
    protected void onSetupEnd(@NotNull Player player, @NotNull ArenaSpotState arenaSpotState) {
        if (this.visualTask != null) {
            this.visualTask.stop();
            this.visualTask = null;
        }
        SpotSettingsEditor spotSettingsEditor = arenaSpotState.getSpot().getEditor();
        spotSettingsEditor.getStatesEditor().open(player, 1);
    }

    @Override
    protected void handleItem(@NotNull PlayerInteractEvent playerInteractEvent, @NotNull Player player, @NotNull ArenaSpotState arenaSpotState, @NotNull ItemStack itemStack, @NotNull SetupItemType setupItemType) {
        switch (setupItemType) {
            case SPOT_STATE_PREVIEW: {
                arenaSpotState.build();
                break;
            }
            case SPOT_STATE_EXIT: {
                this.endSetup(player);
                break;
            }
            case SPOT_SAVE: {
                ArenaCuboid arenaCuboid = arenaSpotState.getSpot().getCuboid().orElse(null);
                if (arenaCuboid != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Block block : arenaCuboid.getBlocks()) {
                        String string = LocationUtil.serialize((Location)block.getLocation());
                        String string2 = block.getBlockData().getAsString();
                        arrayList.add(string + "~" + string2);
                    }
                    arenaSpotState.setSchemeRaw(arrayList);
                    arenaSpotState.getSpot().save();
                }
                this.endSetup(player);
            }
        }
    }

    @Override
    protected void updateVisuals() {
        ArenaCuboid arenaCuboid = ((ArenaSpotState)this.getObject()).getSpot().getCuboid().orElse(null);
        if (arenaCuboid == null) {
            return;
        }
        Location location = arenaCuboid.getMin();
        Location location2 = arenaCuboid.getMax();
        ArenaSetupUtils.addVisualText(this.player, "&9\u00ab 1st Corner \u00bb", location);
        ArenaSetupUtils.addVisualBlock(this.player, location);
        ArenaSetupUtils.addVisualText(this.player, "&9\u00ab 2nd Corner \u00bb", location2);
        ArenaSetupUtils.addVisualBlock(this.player, location2);
    }

    private void updateVisualParticles(@NotNull Player player) {
        ((ArenaSpotState)this.getObject()).getSpot().getCuboid().ifPresent(arenaCuboid -> arenaCuboid.getVisualizer().draw(player));
    }

    @Override
    protected void removeVisuals() {
        ArenaSetupUtils.removeVisuals(this.player);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSpotBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        Player player = blockPlaceEvent.getPlayer();
        if (!this.isEditing(player)) {
            return;
        }
        ArenaSpot arenaSpot = ((ArenaSpotState)this.getObject()).getSpot();
        Block block = blockPlaceEvent.getBlock();
        ArenaCuboid arenaCuboid = arenaSpot.getCuboid().orElse(null);
        if (arenaCuboid == null || !arenaCuboid.contains(block.getLocation())) {
            ((AMA)this.plugin).getMessage(Lang.SETUP_SPOT_STATE_ERROR_OUTSIDE).send((CommandSender)player);
            blockPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSpotBlockBreak(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        if (!this.isEditing(player)) {
            return;
        }
        ArenaSpot arenaSpot = ((ArenaSpotState)this.getObject()).getSpot();
        Block block = blockBreakEvent.getBlock();
        ArenaCuboid arenaCuboid = arenaSpot.getCuboid().orElse(null);
        if (arenaCuboid == null || !arenaCuboid.contains(block.getLocation())) {
            ((AMA)this.plugin).getMessage(Lang.SETUP_SPOT_STATE_ERROR_OUTSIDE).send((CommandSender)player);
            blockBreakEvent.setCancelled(true);
        }
    }

    class VisualTask
    extends AbstractTask<AMA> {
        public VisualTask() {
            super((NexPlugin)((AMA)SpotStateSetupManager.this.plugin), 10L, true);
        }

        public void action() {
            if (SpotStateSetupManager.this.player == null) {
                return;
            }
            SpotStateSetupManager.this.updateVisualParticles(SpotStateSetupManager.this.player);
        }
    }
}

