/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.shop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.ConfigHolder;
import su.nexmedia.engine.api.manager.Loadable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.api.event.ArenaShopEvent;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.editor.shop.ShopManagerEditor;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.lock.LockState;
import su.nightexpress.ama.arena.lock.Lockable;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.Parameters;
import su.nightexpress.ama.arena.script.action.ScriptActions;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;
import su.nightexpress.ama.arena.shop.impl.ShopProduct;
import su.nightexpress.ama.arena.shop.menu.ShopMainMenu;
import su.nightexpress.ama.config.Lang;

public class ShopManager
implements ConfigHolder,
ArenaChild,
Lockable,
Loadable,
Problematic,
Placeholder {
    private static final String CONFIG_NAME = "shop.yml";
    private final ArenaConfig arenaConfig;
    private final JYML config;
    private final Map<String, ShopCategory> categories;
    private final PlaceholderMap placeholderMap;
    private boolean isActive;
    private boolean isHideOtherKitProducts;
    private LockState lockState;
    private ShopMainMenu menu;
    private ShopManagerEditor editor;

    public ShopManager(@NotNull ArenaConfig arenaConfig) {
        this.arenaConfig = arenaConfig;
        this.config = new JYML(arenaConfig.getFile().getParentFile().getAbsolutePath(), CONFIG_NAME);
        this.categories = new LinkedHashMap<String, ShopCategory>();
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems())).add("%shop_manager_is_active%", () -> LangManager.getBoolean((boolean)this.isActive())).add("%shop_manager_hide_other_kit_items%", () -> LangManager.getBoolean((boolean)this.isHideOtherKitProducts()));
    }

    public void setup() {
        Object object7;
        ArenaChild arenaChild;
        Object object2;
        this.setActive(this.config.getBoolean("Settings.Active"));
        this.setHideOtherKitProducts(this.config.getBoolean("Settings.Hide_Other_Kit_Products"));
        this.lockState = LockState.UNLOCKED;
        for (LockState object6 : LockState.values()) {
            for (String string3 : this.config.getSection("Settings.State." + object6.name() + ".Triggers")) {
                ArenaGameEventType arenaGameEventType = StringUtil.getEnum((String)string3, ArenaGameEventType.class).orElse(null);
                if (arenaGameEventType == null) continue;
                object2 = "shop_" + object6.name().toLowerCase();
                arenaChild = new ArenaScript(this.arenaConfig, (String)object2, arenaGameEventType);
                String string2 = this.config.getString("Settings.State." + object6.name() + ".Triggers." + string3, "");
                Object object3 = ArenaScript.ofGameTrigger(arenaGameEventType, string2);
                ((ArenaScript)arenaChild).getConditions().putAll((Map<String, List<ScriptPreparedCondition>>)object3);
                object7 = new ScriptPreparedAction(object6 == LockState.LOCKED ? ScriptActions.LOCK_SHOP : ScriptActions.UNLOCK_SHOP, new ParameterResult());
                ((ArenaScript)arenaChild).getActions().add((ScriptPreparedAction)object7);
                this.getArenaConfig().getScriptManager().addConverted((ArenaScript)arenaChild);
            }
            this.config.remove("Settings.State." + object6.name() + ".Triggers");
        }
        for (String string : this.config.getSection("Categories")) {
            Object object4;
            Object object5;
            Object object6;
            String string3;
            String string32 = "Categories." + string + ".";
            String string4 = this.config.getString(string32 + "Name", string);
            List list = this.config.getStringList(string32 + "Description");
            string3 = this.config.getItem(string32 + "Icon");
            for (LockState lockState : LockState.values()) {
                for (Object object7 : this.config.getSection(string32 + "State." + lockState.name() + ".Triggers")) {
                    object6 = StringUtil.getEnum((String)object7, ArenaGameEventType.class).orElse(null);
                    if (object6 == null) continue;
                    object5 = "shop_category_" + string + "_" + lockState.name().toLowerCase();
                    object4 = new ArenaScript(this.arenaConfig, (String)object5, (ArenaGameEventType)((Object)object6));
                    String string5 = this.config.getString(string32 + "State." + lockState.name() + ".Triggers." + (String)object7, "");
                    Map<String, List<ScriptPreparedCondition>> map = ArenaScript.ofGameTrigger(object6, string5);
                    ((ArenaScript)object4).getConditions().putAll(map);
                    ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(lockState == LockState.LOCKED ? ScriptActions.LOCK_SHOP_CATEGORY : ScriptActions.UNLOCK_SHOP_CATEGORY, new ParameterResult());
                    scriptPreparedAction.getParameters().add(Parameters.SHOP_CATEGORY, string);
                    ((ArenaScript)object4).getActions().add(scriptPreparedAction);
                    this.getArenaConfig().getScriptManager().addConverted((ArenaScript)object4);
                }
                this.config.remove(string32 + "State." + lockState.name() + ".Triggers");
            }
            Set set = this.config.getStringSet(string32 + "Allowed_Kits");
            object2 = new LinkedHashMap();
            arenaChild = new ShopCategory(this.arenaConfig, string, string4, list, (ItemStack)string3, set, (Map<String, ShopProduct>)object2);
            for (Object object3 : this.config.getSection(string32 + "Products")) {
                if (!this.plugin().getCurrencyManager().hasCurrency()) continue;
                object7 = string32 + "Products." + (String)object3 + ".";
                object6 = this.config.getString((String)object7 + "Name", (String)object3);
                object5 = this.config.getStringList((String)object7 + "Description");
                object4 = this.plugin().getCurrencyManager().getCurrency(this.config.getString((String)object7 + "Currency", ""));
                if (object4 == null) {
                    object4 = this.plugin().getCurrencyManager().getAny();
                }
                double d = this.config.getDouble((String)object7 + "Price");
                for (LockState lockState : LockState.values()) {
                    for (String string6 : this.config.getSection((String)object7 + "State." + lockState.name() + ".Triggers")) {
                        ArenaGameEventType arenaGameEventType = StringUtil.getEnum((String)string6, ArenaGameEventType.class).orElse(null);
                        if (arenaGameEventType == null) continue;
                        String string7 = "shop_product_" + string + "_" + (String)object3 + "_" + lockState.name().toLowerCase();
                        ArenaScript arenaScript = new ArenaScript(this.arenaConfig, string7, arenaGameEventType);
                        String string8 = this.config.getString((String)object7 + "State." + lockState.name() + ".Triggers." + string6, "");
                        Map<String, List<ScriptPreparedCondition>> map = ArenaScript.ofGameTrigger(arenaGameEventType, string8);
                        arenaScript.getConditions().putAll(map);
                        ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(lockState == LockState.LOCKED ? ScriptActions.LOCK_SHOP_PRODUCT : ScriptActions.UNLOCK_SHOP_PRODUCT, new ParameterResult());
                        scriptPreparedAction.getParameters().add(Parameters.SHOP_CATEGORY, string);
                        scriptPreparedAction.getParameters().add(Parameters.SHOP_PRODUCT, object3);
                        arenaScript.getActions().add(scriptPreparedAction);
                        this.getArenaConfig().getScriptManager().addConverted(arenaScript);
                    }
                    this.config.remove((String)object7 + "State." + lockState.name() + ".Triggers");
                }
                Set set2 = this.config.getStringSet((String)object7 + "Allowed_Kits");
                ItemStack itemStack = this.config.getItem((String)object7 + "Preview");
                if (itemStack.getType().isAir()) {
                    this.plugin().error("Null preview for '" + (String)object3 + "' item in '" + this.arenaConfig.getId() + "' arena shop!");
                }
                List list2 = this.config.getStringList((String)object7 + "Commands");
                List<ItemStack> list3 = Arrays.asList(this.config.getItemsEncoded((String)object7 + "Items"));
                ShopProduct shopProduct = new ShopProduct((ShopCategory)arenaChild, (String)object3, (String)object6, (List<String>)object5, (Currency)object4, d, set2, itemStack, list2, list3);
                ((ShopCategory)arenaChild).getProductsMap().put(shopProduct.getId(), shopProduct);
            }
            this.categories.put(((ShopCategory)arenaChild).getId(), (ShopCategory)arenaChild);
        }
        this.config.saveChanges();
    }

    public void shutdown() {
        this.getCategories().forEach(ShopCategory::clear);
        this.categories.clear();
        if (this.menu != null) {
            this.menu.clear();
            this.menu = null;
        }
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
    }

    public void onSave() {
        this.config.set("Settings.Active", (Object)this.isActive());
        this.config.set("Settings.Hide_Other_Kit_Products", (Object)this.isHideOtherKitProducts());
        this.config.set("Settings.State", null);
        this.config.set("Categories", null);
        this.getCategories().forEach(shopCategory -> {
            String string = "Categories." + shopCategory.getId() + ".";
            this.config.set(string + "Name", (Object)shopCategory.getName());
            this.config.set(string + "Description", shopCategory.getDescription());
            this.config.setItem(string + "Icon", shopCategory.getIcon());
            this.config.set(string + "Allowed_Kits", shopCategory.getAllowedKits());
            shopCategory.getProducts().forEach(shopProduct -> {
                String string2 = string + "Products." + shopProduct.getId() + ".";
                this.config.set(string2 + "Name", (Object)shopProduct.getName());
                this.config.set(string2 + "Description", shopProduct.getDescription());
                this.config.set(string2 + "Price", (Object)shopProduct.getPrice());
                this.config.set(string2 + "Allowed_Kits", shopProduct.getAllowedKits());
                this.config.setItem(string2 + "Preview", shopProduct.getIcon());
                this.config.set(string2 + "Commands", shopProduct.getCommands());
                this.config.setItemsEncoded(string2 + "Items", shopProduct.getItems());
            });
        });
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public JYML getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        return new ArrayList<String>();
    }

    @NotNull
    public ShopManagerEditor getEditor() {
        if (this.editor == null) {
            this.editor = new ShopManagerEditor(this);
        }
        return this.editor;
    }

    @NotNull
    public ShopMainMenu getMenu() {
        if (this.menu == null) {
            this.menu = new ShopMainMenu(this);
        }
        return this.menu;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    @Override
    @NotNull
    public LockState getLockState() {
        return this.lockState;
    }

    @Override
    public void setLockState(@NotNull LockState lockState) {
        this.lockState = lockState;
        ArenaGameEventType arenaGameEventType = this.isLocked() ? ArenaGameEventType.SHOP_LOCKED : ArenaGameEventType.SHOP_UNLOCKED;
        ArenaShopEvent arenaShopEvent = new ArenaShopEvent(this.getArena(), arenaGameEventType);
        this.plugin().getPluginManager().callEvent((Event)arenaShopEvent);
    }

    public boolean isHideOtherKitProducts() {
        return this.isHideOtherKitProducts;
    }

    public void setHideOtherKitProducts(boolean bl) {
        this.isHideOtherKitProducts = bl;
    }

    @NotNull
    public Map<String, ShopCategory> getCategoryMap() {
        return this.categories;
    }

    @NotNull
    public Collection<ShopCategory> getCategories() {
        return this.getCategoryMap().values();
    }

    @Nullable
    public ShopCategory getCategory(@NotNull String string) {
        return this.getCategoryMap().get(string.toLowerCase());
    }

    public boolean createCategory(@NotNull String string) {
        if (this.getCategory(string) != null) {
            return false;
        }
        ShopCategory shopCategory = new ShopCategory(this.getArenaConfig(), string);
        this.getCategoryMap().put(shopCategory.getId(), shopCategory);
        return true;
    }

    public boolean open(@NotNull Player player) {
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return false;
        }
        Arena arena = arenaPlayer.getArena();
        if (arena.getState() != GameState.INGAME || !this.isActive()) {
            this.plugin().getMessage(Lang.SHOP_OPEN_ERROR_DISABLED).send((CommandSender)player);
            return false;
        }
        if (this.isLocked()) {
            this.plugin().getMessage(Lang.SHOP_OPEN_ERROR_LOCKED).send((CommandSender)player);
            return false;
        }
        this.getMenu().open(player, 1);
        return true;
    }
}

