/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.shop.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.PlayerUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.api.event.ArenaShopProductEvent;
import su.nightexpress.ama.arena.editor.shop.ShopProductSettingsEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.lock.LockState;
import su.nightexpress.ama.arena.lock.Lockable;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.stats.object.StatType;

public class ShopProduct
implements ArenaChild,
Lockable,
Placeholder {
    private final ShopCategory shopCategory;
    private final String id;
    private final PlaceholderMap placeholderMap;
    private String name;
    private List<String> description;
    private LockState lockState;
    private Currency currency;
    private double price;
    private Set<String> allowedKits;
    private ItemStack icon;
    private List<String> commands;
    private List<ItemStack> items;
    private ShopProductSettingsEditor editor;

    public ShopProduct(@NotNull ShopCategory shopCategory, @NotNull String string, @NotNull Currency currency) {
        this(shopCategory, string, StringUtil.capitalizeUnderscored((String)string), new ArrayList<String>(), currency, 10.0, new HashSet<String>(), new ItemStack(Material.APPLE), new ArrayList<String>(), new ArrayList<ItemStack>());
    }

    public ShopProduct(@NotNull ShopCategory shopCategory, @NotNull String string, @NotNull String string2, @NotNull List<String> list, @NotNull Currency currency, double d, @NotNull Set<String> set, @NotNull ItemStack itemStack, @NotNull List<String> list2, @NotNull List<ItemStack> list3) {
        this.shopCategory = shopCategory;
        this.id = string.toLowerCase();
        this.setName(string2);
        this.setDescription(list);
        this.lockState = LockState.UNLOCKED;
        this.setCurrency(currency);
        this.setPrice(d);
        this.setAllowedKits(set);
        this.setIcon(itemStack);
        this.setCommands(list2);
        this.setItems(list3);
        this.placeholderMap = new PlaceholderMap().add("%shop_product_id%", this::getId).add("%shop_product_name%", this::getName).add("%shop_product_description%", () -> String.join((CharSequence)"\n", this.getDescription())).add("%shop_product_price%", () -> this.getCurrency().format(this.getPrice())).add("%shop_product_currency%", () -> this.getCurrency().getName()).add("%shop_product_allowed_kits%", () -> this.getAllowedKits().stream().map(string -> this.plugin().getKitManager().getKitById((String)string)).filter(Objects::nonNull).map(Kit::getName).map(Colorizer::strip).collect(Collectors.joining(", "))).add("%shop_product_commands%", () -> String.join((CharSequence)"\n", this.getCommands()));
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    public boolean purchase(@NotNull ArenaPlayer arenaPlayer) {
        Player player = arenaPlayer.getPlayer();
        if (this.isLocked()) {
            this.plugin().getMessage(Lang.SHOP_PRODUCT_ERROR_LOCKED).send((CommandSender)player);
            return false;
        }
        if (!this.isAvailable(arenaPlayer)) {
            this.plugin().getMessage(Lang.SHOP_PRODUCT_ERROR_UNAVAILABLE).send((CommandSender)player);
            return false;
        }
        double d = this.getPrice();
        double d2 = this.getCurrency().getHandler().getBalance(player);
        if (d2 < d) {
            this.plugin().getMessage(Lang.SHOP_PRODUCT_ERROR_NOT_ENOUGH_FUNDS).replace(this.replacePlaceholders()).send((CommandSender)player);
            return false;
        }
        this.getCurrency().getHandler().take(player, d);
        this.give(player);
        arenaPlayer.addStats(StatType.COINS_SPENT, (int)d);
        this.plugin().getMessage(Lang.SHOP_PRODUCT_PURCHASE).replace(this.replacePlaceholders()).send((CommandSender)player);
        return true;
    }

    public boolean isAvailable(@NotNull ArenaPlayer arenaPlayer) {
        if (this.getArenaConfig().getGameplayManager().isKitsEnabled()) {
            if (this.getAllowedKits().isEmpty() || this.getAllowedKits().contains("*")) {
                return true;
            }
            Kit kit = arenaPlayer.getKit();
            return kit != null && this.getAllowedKits().contains(kit.getId());
        }
        return true;
    }

    @NotNull
    public ShopProductSettingsEditor getEditor() {
        if (this.editor == null) {
            this.editor = new ShopProductSettingsEditor(this);
        }
        return this.editor;
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.getDescription().clear();
        this.getItems().clear();
        this.getCommands().clear();
        this.getAllowedKits().clear();
    }

    public void give(@NotNull Player player) {
        this.getCommands().forEach(string -> PlayerUtil.dispatchCommand((Player)player, (String)string));
        this.getItems().forEach(itemStack -> PlayerUtil.addItem((Player)player, (ItemStack[])new ItemStack[]{itemStack}));
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.getShopCategory().getArenaConfig();
    }

    @NotNull
    public ShopCategory getShopCategory() {
        return this.shopCategory;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        this.name = Colorizer.apply((String)string);
    }

    @NotNull
    public List<String> getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull List<String> list) {
        this.description = Colorizer.apply(list);
    }

    @Override
    @NotNull
    public LockState getLockState() {
        return this.lockState;
    }

    @Override
    public void setLockState(@NotNull LockState lockState) {
        this.lockState = lockState;
        ArenaGameEventType arenaGameEventType = this.isLocked() ? ArenaGameEventType.SHOP_ITEM_LOCKED : ArenaGameEventType.SHOP_ITEM_UNLOCKED;
        ArenaShopProductEvent arenaShopProductEvent = new ArenaShopProductEvent(this.getArena(), arenaGameEventType, this);
        this.plugin().getPluginManager().callEvent((Event)arenaShopProductEvent);
    }

    @NotNull
    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(@NotNull Currency currency) {
        this.currency = currency;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double d) {
        this.price = d;
    }

    @NotNull
    public Set<String> getAllowedKits() {
        return this.allowedKits;
    }

    public void setAllowedKits(@NotNull Set<String> set) {
        this.allowedKits = new HashSet<String>(set.stream().map(String::toLowerCase).toList());
    }

    @NotNull
    public ItemStack getIcon() {
        return new ItemStack(this.icon);
    }

    public void setIcon(@NotNull ItemStack itemStack) {
        this.icon = new ItemStack(itemStack);
        ItemUtil.mapMeta((ItemStack)this.icon, itemMeta -> {
            itemMeta.setDisplayName(null);
            itemMeta.setLore(null);
            itemMeta.addItemFlags(ItemFlag.values());
        });
    }

    @NotNull
    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(@NotNull List<String> list) {
        this.commands = new ArrayList<String>(list);
    }

    @NotNull
    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(@NotNull List<ItemStack> list) {
        this.items = new ArrayList<ItemStack>(list);
        this.getItems().removeIf(itemStack -> itemStack == null || itemStack.getType().isAir());
    }
}

