/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.shop.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.MenuItemType;
import su.nexmedia.engine.api.menu.click.ClickHandler;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.ConfigMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;
import su.nightexpress.ama.arena.shop.impl.ShopProduct;

public class ShopCategoryMenu
extends ConfigMenu<AMA>
implements AutoPaged<ShopProduct> {
    private static final String PLACEHOLDER_KITS = "%kits%";
    private static final String PLACEHOLDER_UNLOCKED = "%unlocked%";
    private static final String PLACEHOLDER_LOCKED = "%locked%";
    private final ShopCategory shopCategory;
    private final String itemName;
    private final List<String> itemLoreDefault;
    private final List<String> itemLoreKits;
    private final List<String> itemLoreUnlocked;
    private final List<String> itemLoreLocked;
    private final int[] itemSlots;

    public ShopCategoryMenu(@NotNull ShopCategory shopCategory) {
        super((NexPlugin)shopCategory.plugin(), JYML.loadOrExtract((NexPlugin)shopCategory.plugin(), (String)"/menu/arena.shop.category.yml"));
        this.shopCategory = shopCategory;
        this.itemName = Colorizer.apply((String)this.cfg.getString("Product.Name", "%shop_product_name%"));
        this.itemLoreDefault = Colorizer.apply((List)this.cfg.getStringList("Product.Lore.Default"));
        this.itemLoreKits = Colorizer.apply((List)this.cfg.getStringList("Product.Lore.Kits"));
        this.itemLoreUnlocked = Colorizer.apply((List)this.cfg.getStringList("Product.Lore.Unlocked"));
        this.itemLoreLocked = Colorizer.apply((List)this.cfg.getStringList("Product.Lore.Locked"));
        this.itemSlots = this.cfg.getIntArray("Product.Slots");
        this.registerHandler(MenuItemType.class).addClick((Enum)MenuItemType.CLOSE, (menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).runTask(bukkitTask -> menuViewer.getPlayer().closeInventory())).addClick((Enum)MenuItemType.RETURN, (menuViewer, inventoryClickEvent) -> {
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(menuViewer.getPlayer());
            if (arenaPlayer != null) {
                this.shopCategory.open(arenaPlayer);
            }
        }).addClick((Enum)MenuItemType.PAGE_NEXT, ClickHandler.forNextPage((Menu)this)).addClick((Enum)MenuItemType.PAGE_PREVIOUS, ClickHandler.forPreviousPage((Menu)this));
        this.load();
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((ShopCategoryMenu)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return this.itemSlots;
    }

    @NotNull
    public List<ShopProduct> getObjects(@NotNull Player player) {
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null || arenaPlayer.getArena().getState() != GameState.INGAME) {
            return Collections.emptyList();
        }
        ArrayList<ShopProduct> arrayList = new ArrayList<ShopProduct>(this.shopCategory.getProducts());
        if (this.shopCategory.getShopManager().isHideOtherKitProducts()) {
            arrayList.removeIf(shopProduct -> !shopProduct.isAvailable(arenaPlayer));
        }
        return arrayList;
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ShopProduct shopProduct) {
        ItemStack itemStack = shopProduct.getIcon();
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            List<String> list = new ArrayList<String>(this.itemLoreDefault);
            list = StringUtil.replaceInList(list, (String)PLACEHOLDER_KITS, shopProduct.getAllowedKits().isEmpty() ? Collections.emptyList() : this.itemLoreKits);
            list = StringUtil.replaceInList(list, (String)PLACEHOLDER_LOCKED, shopProduct.isLocked() ? this.itemLoreLocked : Collections.emptyList());
            list = StringUtil.replaceInList(list, (String)PLACEHOLDER_UNLOCKED, shopProduct.isUnlocked() ? this.itemLoreUnlocked : Collections.emptyList());
            itemMeta.setDisplayName(this.itemName);
            itemMeta.setLore(list);
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)shopProduct.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ShopProduct shopProduct) {
        return (menuViewer, inventoryClickEvent) -> {
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(menuViewer.getPlayer());
            if (arenaPlayer == null) {
                menuViewer.getPlayer().closeInventory();
                return;
            }
            shopProduct.purchase(arenaPlayer);
        };
    }
}

