/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.shop.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.MenuItemType;
import su.nexmedia.engine.api.menu.click.ClickHandler;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.ConfigMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.shop.ShopManager;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;

public class ShopMainMenu
extends ConfigMenu<AMA>
implements AutoPaged<ShopCategory> {
    private static final String PLACEHOLDER_KITS = "%kits%";
    private static final String PLACEHOLDER_UNLOCKED = "%unlocked%";
    private static final String PLACEHOLDER_LOCKED = "%locked%";
    private final ShopManager shopManager;
    private final String categoryName;
    private final List<String> categoryLoreDefault;
    private final List<String> categoryLoreKits;
    private final List<String> categoryLoreUnlocked;
    private final List<String> categoryLoreLocked;
    private final int[] categorySlots;

    public ShopMainMenu(@NotNull ShopManager shopManager) {
        super((NexPlugin)shopManager.plugin(), JYML.loadOrExtract((NexPlugin)shopManager.plugin(), (String)"/menu/arena.shop.main.yml"));
        this.shopManager = shopManager;
        this.categoryName = Colorizer.apply((String)this.cfg.getString("Category.Name", "%shop_category_name%"));
        this.categoryLoreDefault = Colorizer.apply((List)this.cfg.getStringList("Category.Lore.Default"));
        this.categoryLoreKits = Colorizer.apply((List)this.cfg.getStringList("Category.Lore.Kits"));
        this.categoryLoreUnlocked = Colorizer.apply((List)this.cfg.getStringList("Category.Lore.Unlocked"));
        this.categoryLoreLocked = Colorizer.apply((List)this.cfg.getStringList("Category.Lore.Locked"));
        this.categorySlots = this.cfg.getIntArray("Category.Slots");
        this.registerHandler(MenuItemType.class).addClick((Enum)MenuItemType.CLOSE, (menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).runTask(bukkitTask -> menuViewer.getPlayer().closeInventory())).addClick((Enum)MenuItemType.PAGE_NEXT, ClickHandler.forNextPage((Menu)this)).addClick((Enum)MenuItemType.PAGE_PREVIOUS, ClickHandler.forPreviousPage((Menu)this));
        this.load();
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((ShopMainMenu)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return this.categorySlots;
    }

    @NotNull
    public List<ShopCategory> getObjects(@NotNull Player player) {
        return new ArrayList<ShopCategory>(this.shopManager.getCategories());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ShopCategory shopCategory) {
        ItemStack itemStack = shopCategory.getIcon();
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            List<String> list = new ArrayList<String>(this.categoryLoreDefault);
            list = StringUtil.replaceInList(list, (String)PLACEHOLDER_KITS, shopCategory.getAllowedKits().isEmpty() ? Collections.emptyList() : this.categoryLoreKits);
            list = StringUtil.replaceInList(list, (String)PLACEHOLDER_LOCKED, shopCategory.isLocked() ? this.categoryLoreLocked : Collections.emptyList());
            list = StringUtil.replaceInList(list, (String)PLACEHOLDER_UNLOCKED, shopCategory.isUnlocked() ? this.categoryLoreUnlocked : Collections.emptyList());
            itemMeta.setDisplayName(this.categoryName);
            itemMeta.setLore(list);
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)shopCategory.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ShopCategory shopCategory) {
        return (menuViewer, inventoryClickEvent) -> {
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(menuViewer.getPlayer());
            if (arenaPlayer != null) {
                shopCategory.open(arenaPlayer);
            }
        };
    }
}

