/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.spot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.arena.editor.spot.SpotSettingsEditor;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.Parameters;
import su.nightexpress.ama.arena.script.action.ScriptActions;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.arena.spot.ArenaSpotState;
import su.nightexpress.ama.arena.util.ArenaCuboid;

public class ArenaSpot
extends AbstractConfigHolder<AMA>
implements ArenaChild,
Problematic,
Placeholder {
    private final ArenaConfig arenaConfig;
    private final Map<String, ArenaSpotState> states;
    private final PlaceholderMap placeholderMap;
    private boolean isActive;
    private String name;
    private ArenaCuboid cuboid;
    private SpotSettingsEditor editor;

    public ArenaSpot(@NotNull ArenaConfig arenaConfig, @NotNull JYML jYML) {
        super((NexPlugin)((AMA)arenaConfig.plugin()), jYML);
        this.arenaConfig = arenaConfig;
        this.states = new HashMap<String, ArenaSpotState>();
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems())).add("%spot_id%", () -> ((ArenaSpot)this).getId()).add("%spot_name%", this::getName).add("%spot_active%", () -> LangManager.getBoolean((boolean)this.isActive()));
    }

    public boolean load() {
        this.setActive(this.cfg.getBoolean("Enabled"));
        this.setName(this.cfg.getString("Name", this.getId()));
        Location location = this.cfg.getLocation("Bounds.From");
        Location location2 = this.cfg.getLocation("Bounds.To");
        if (location != null && location2 != null) {
            this.setCuboid(new ArenaCuboid(location, location2));
        }
        for (String string : this.cfg.getSection("States")) {
            Object object2;
            String string2 = "States." + string + ".";
            for (Object object2 : this.cfg.getSection(string2 + "Triggers")) {
                ArenaGameEventType arenaGameEventType = StringUtil.getEnum((String)object2, ArenaGameEventType.class).orElse(null);
                if (arenaGameEventType == null) continue;
                String string3 = "spot_change_" + this.getId() + "_to_" + string;
                ArenaScript arenaScript = new ArenaScript(this.arenaConfig, string3, arenaGameEventType);
                String string4 = this.cfg.getString(string2 + "Triggers." + (String)object2, "");
                Map<String, List<ScriptPreparedCondition>> map = ArenaScript.ofGameTrigger(arenaGameEventType, string4);
                arenaScript.getConditions().putAll(map);
                ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(ScriptActions.CHANGE_SPOT, new ParameterResult());
                scriptPreparedAction.getParameters().add(Parameters.SPOT, this.getId());
                scriptPreparedAction.getParameters().add(Parameters.STATE, string);
                arenaScript.getActions().add(scriptPreparedAction);
                this.getArenaConfig().getScriptManager().addConverted(arenaScript);
            }
            this.cfg.remove(string2 + "Triggers");
            ArrayList arrayList = new ArrayList(this.cfg.getStringList(string2 + "Scheme"));
            object2 = new ArenaSpotState(this, string, arrayList);
            this.states.put(((ArenaSpotState)object2).getId(), (ArenaSpotState)object2);
        }
        this.cfg.saveChanges();
        return true;
    }

    public void onSave() {
        this.cfg.set("Enabled", (Object)this.isActive());
        this.cfg.set("Name", (Object)this.getName());
        this.cfg.set("Bounds", null);
        this.getCuboid().ifPresent(arenaCuboid -> {
            this.cfg.set("Bounds.From", (Object)arenaCuboid.getMin());
            this.cfg.set("Bounds.To", (Object)arenaCuboid.getMax());
        });
        this.cfg.set("States", null);
        this.states.forEach((string, arenaSpotState) -> {
            String string2 = "States." + string + ".";
            this.cfg.set(string2 + "Scheme", arenaSpotState.getSchemeRaw());
        });
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getCuboid().isEmpty()) {
            arrayList.add(this.problem("Invalid Cuboid Selection!"));
        }
        if (this.getStates().isEmpty()) {
            arrayList.add(this.problem("No Spot States!"));
        }
        return arrayList;
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
    }

    @NotNull
    public SpotSettingsEditor getEditor() {
        if (this.editor == null) {
            this.editor = new SpotSettingsEditor(this);
        }
        return this.editor;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        this.name = Colorizer.apply((String)string);
    }

    @NotNull
    public Optional<ArenaCuboid> getCuboid() {
        return Optional.ofNullable(this.cuboid);
    }

    public void setCuboid(@Nullable ArenaCuboid arenaCuboid) {
        this.cuboid = arenaCuboid;
    }

    @NotNull
    public Map<String, ArenaSpotState> getStates() {
        return this.states;
    }

    @Nullable
    public ArenaSpotState getState(@NotNull String string) {
        return this.getStates().get(string.toLowerCase());
    }

    public void setState(@NotNull Arena arena, @NotNull String string) {
        ArenaSpotState arenaSpotState = this.getState(string);
        if (arenaSpotState == null) {
            return;
        }
        arenaSpotState.build(arena);
    }
}

