/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.spot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.Loadable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.arena.editor.spot.SpotListEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.spot.ArenaSpot;

public class ArenaSpotManager
implements ArenaChild,
Loadable,
Problematic,
Placeholder {
    public static final String DIR_SPOTS = "/spots/";
    private final ArenaConfig arenaConfig;
    private final Map<String, ArenaSpot> spots;
    private final PlaceholderMap placeholderMap;
    private SpotListEditor editor;

    public ArenaSpotManager(@NotNull ArenaConfig arenaConfig) {
        this.arenaConfig = arenaConfig;
        this.spots = new HashMap<String, ArenaSpot>();
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems()));
    }

    public void setup() {
        for (JYML jYML : JYML.loadAll((String)this.getSpotsPath(), (boolean)false)) {
            ArenaSpot arenaSpot = new ArenaSpot(this.arenaConfig, jYML);
            if (arenaSpot.load()) {
                this.spots.put(arenaSpot.getId(), arenaSpot);
                continue;
            }
            ((AMA)this.arenaConfig.plugin()).error("Spot not loaded: '" + jYML.getFile().getName() + "' spot for '" + this.arenaConfig.getId() + "' arena!");
        }
    }

    public void shutdown() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.getSpots().forEach(ArenaSpot::clear);
        this.getSpotsMap().clear();
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @NotNull
    public String getSpotsPath() {
        return this.getArenaConfig().getFile().getParentFile().getAbsolutePath() + DIR_SPOTS;
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getSpots().forEach(arenaSpot -> {
            if (arenaSpot.isActive() && arenaSpot.hasProblems()) {
                arrayList.add(this.problem("Problems with '" + arenaSpot.getId() + "' spot!"));
            }
        });
        return arrayList;
    }

    @NotNull
    public SpotListEditor getEditor() {
        if (this.editor == null) {
            this.editor = new SpotListEditor(this);
        }
        return this.editor;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public Map<String, ArenaSpot> getSpotsMap() {
        return this.spots;
    }

    @NotNull
    public Collection<ArenaSpot> getSpots() {
        return this.getSpotsMap().values();
    }

    public boolean createSpot(@NotNull String string) {
        if (this.getSpot(string) != null) {
            return false;
        }
        String string2 = this.getSpotsPath() + string + ".yml";
        ArenaSpot arenaSpot = new ArenaSpot(this.getArenaConfig(), new JYML(this.getSpotsPath(), string + ".yml"));
        arenaSpot.setActive(false);
        arenaSpot.setName(StringUtil.capitalizeUnderscored((String)arenaSpot.getId()) + " Spot");
        arenaSpot.save();
        arenaSpot.load();
        this.addSpot(arenaSpot);
        return true;
    }

    public void addSpot(@NotNull ArenaSpot arenaSpot) {
        this.getSpotsMap().put(arenaSpot.getId(), arenaSpot);
    }

    public void removeSpot(@NotNull ArenaSpot arenaSpot) {
        if (arenaSpot.getFile().delete()) {
            arenaSpot.clear();
            this.getSpotsMap().remove(arenaSpot.getId());
        }
    }

    @Nullable
    public ArenaSpot getSpot(@NotNull String string) {
        return this.getSpotsMap().get(string.toLowerCase());
    }

    @Nullable
    public ArenaSpot getSpot(@NotNull Location location) {
        return this.getSpots().stream().filter(arenaSpot -> arenaSpot.getCuboid().isPresent() && arenaSpot.getCuboid().get().contains(location)).findFirst().orElse(null);
    }
}

