/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.supply;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.arena.editor.supply.SupplyChestSettingsEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;

public class ArenaSupplyChest
implements ArenaChild,
Placeholder {
    private final ArenaConfig arenaConfig;
    private final String id;
    private final PlaceholderMap placeholderMap;
    private Location location;
    private int minItems;
    private int maxItems;
    private List<ItemStack> items;
    private SupplyChestSettingsEditor editor;

    public ArenaSupplyChest(@NotNull ArenaConfig arenaConfig, @NotNull String string) {
        this(arenaConfig, string, null, 1, 10, new ArrayList<ItemStack>());
    }

    public ArenaSupplyChest(@NotNull ArenaConfig arenaConfig, @NotNull String string, @Nullable Location location, int n, int n2, @NotNull List<ItemStack> list) {
        this.arenaConfig = arenaConfig;
        this.id = string.toLowerCase();
        this.setLocation(location);
        this.setMinItems(n);
        this.setMaxItems(n2);
        this.setItems(list);
        this.placeholderMap = new PlaceholderMap().add("%supply_chest_id", this::getId).add("%supply_chest_refill_items_min%", () -> String.valueOf(this.getMinItems())).add("%supply_chest_refill_items_max%", () -> String.valueOf(this.getMaxItems())).add("%supply_chest_location_x%", () -> this.getLocation() == null ? "?" : NumberUtil.format((double)this.getLocation().getX())).add("%supply_chest_location_y%", () -> this.getLocation() == null ? "?" : NumberUtil.format((double)this.getLocation().getY())).add("%supply_chest_location_z%", () -> this.getLocation() == null ? "?" : NumberUtil.format((double)this.getLocation().getZ())).add("%supply_chest_location_world%", () -> {
            Location location = this.getLocation();
            return location == null || location.getWorld() == null ? "?" : LangManager.getWorld((World)location.getWorld());
        });
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
    }

    @NotNull
    public SupplyChestSettingsEditor getEditor() {
        if (this.editor == null) {
            this.editor = new SupplyChestSettingsEditor(this);
        }
        return this.editor;
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public boolean hasContainer() {
        return this.getContainer().isPresent();
    }

    public boolean refill() {
        Container container = this.getContainer().orElse(null);
        if (container == null) {
            return false;
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(this.getItems());
        if (arrayList.isEmpty()) {
            return false;
        }
        int n = Math.min(this.getMinItems(), this.getMaxItems());
        int n2 = Math.max(this.getMinItems(), this.getMaxItems());
        int n3 = Math.min(arrayList.size(), Rnd.get((int)n, (int)n2));
        if (n3 <= 0) {
            return false;
        }
        Inventory inventory = container.getInventory();
        Collections.shuffle(arrayList);
        while (arrayList.size() > n3) {
            arrayList.remove(0);
        }
        while (arrayList.size() < inventory.getSize()) {
            arrayList.add(new ItemStack(Material.AIR));
        }
        Collections.shuffle(arrayList);
        inventory.clear();
        inventory.setContents(arrayList.toArray(new ItemStack[0]));
        return true;
    }

    @NotNull
    public Optional<Container> getContainer() {
        if (this.getLocation() == null) {
            return Optional.empty();
        }
        BlockState blockState = this.getLocation().getBlock().getState();
        if (blockState instanceof Container) {
            Container container = (Container)blockState;
            return Optional.of(container);
        }
        return Optional.empty();
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(@Nullable Location location) {
        this.location = location;
    }

    public int getMinItems() {
        return this.minItems;
    }

    public void setMinItems(int n) {
        this.minItems = n;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int n) {
        this.maxItems = n;
    }

    @NotNull
    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(@NotNull List<ItemStack> list) {
        this.items = new ArrayList<ItemStack>(list);
        this.getItems().removeIf(itemStack -> itemStack == null || itemStack.getType().isAir());
    }
}

