/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.EngineUtils;
import su.nexmedia.engine.utils.EntityUtil;
import su.nightexpress.ama.api.arena.type.ArenaLocationType;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.config.Config;
import su.nightexpress.ama.hook.external.EssentialsHook;
import su.nightexpress.ama.hook.external.SunLightHook;

public class PlayerSnapshot {
    private final Location location;
    private final int foodLevel;
    private final float saturation;
    private final double health;
    private final ItemStack[] inventory;
    private final ItemStack[] armor;
    private final Collection<PotionEffect> effects;
    private final GameMode gameMode;
    private static final Map<UUID, PlayerSnapshot> SNAPSHOTS = new HashMap<UUID, PlayerSnapshot>();

    PlayerSnapshot(@NotNull Player player) {
        this.location = player.getLocation();
        this.foodLevel = player.getFoodLevel();
        this.saturation = player.getSaturation();
        this.health = player.getHealth();
        this.inventory = player.getInventory().getContents();
        this.armor = player.getInventory().getArmorContents();
        this.effects = player.getActivePotionEffects();
        this.gameMode = player.getGameMode();
    }

    public static void doSnapshot(@NotNull Player player) {
        SNAPSHOTS.put(player.getUniqueId(), new PlayerSnapshot(player));
    }

    public static void clear(@NotNull Player player) {
        player.setGameMode(GameMode.SURVIVAL);
        player.setAllowFlight(false);
        player.setFlying(false);
        player.setGliding(false);
        player.setSneaking(false);
        player.setSprinting(false);
        player.setFoodLevel(20);
        player.setSaturation(20.0f);
        player.setHealth(EntityUtil.getAttribute((LivingEntity)player, (Attribute)Attribute.GENERIC_MAX_HEALTH));
        player.setFireTicks(0);
        player.leaveVehicle();
        if (((Boolean)Config.ARENA_CLEAR_POTION_EFFECTS.get()).booleanValue()) {
            player.getActivePotionEffects().forEach(potionEffect -> player.removePotionEffect(potionEffect.getType()));
        }
        if (EngineUtils.hasPlugin((String)"Essentials")) {
            EssentialsHook.disableGod(player);
        }
        if (EngineUtils.hasPlugin((String)"SunLight")) {
            SunLightHook.disableGod(player);
        }
    }

    public static void restore(@NotNull ArenaPlayer arenaPlayer) {
        Player player = arenaPlayer.getPlayer();
        PlayerSnapshot playerSnapshot = SNAPSHOTS.remove(player.getUniqueId());
        if (playerSnapshot == null) {
            return;
        }
        Arena arena = arenaPlayer.getArena();
        Location location = arena.getConfig().getLocation(ArenaLocationType.LEAVE);
        player.teleport(location != null ? location : playerSnapshot.getLocation());
        player.setFoodLevel(playerSnapshot.getFoodLevel());
        player.setSaturation(playerSnapshot.getSaturation());
        player.setHealth(Math.min(EntityUtil.getAttribute((LivingEntity)player, (Attribute)Attribute.GENERIC_MAX_HEALTH), playerSnapshot.getHealth()));
        player.setGameMode(playerSnapshot.getGameMode());
        if (player.getGameMode() == GameMode.CREATIVE) {
            player.setAllowFlight(true);
            player.setFlying(true);
        }
        if (((Boolean)Config.ARENA_CLEAR_POTION_EFFECTS.get()).booleanValue()) {
            player.getActivePotionEffects().stream().map(PotionEffect::getType).forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
            player.addPotionEffects(playerSnapshot.getPotionEffects());
        }
        if (arena.getConfig().getGameplayManager().isKitsEnabled()) {
            player.getInventory().setContents(playerSnapshot.getInventory());
            player.getInventory().setArmorContents(playerSnapshot.getArmor());
        }
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public double getHealth() {
        return this.health;
    }

    @NotNull
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public ItemStack[] getArmor() {
        return this.armor;
    }

    @NotNull
    public Collection<PotionEffect> getPotionEffects() {
        return this.effects;
    }

    @NotNull
    public GameMode getGameMode() {
        return this.gameMode;
    }
}

