/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.wave;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.ConfigHolder;
import su.nexmedia.engine.api.manager.Loadable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.arena.editor.wave.WaveManagerEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.Parameters;
import su.nightexpress.ama.arena.script.action.ScriptActions;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.arena.wave.ArenaWave;
import su.nightexpress.ama.arena.wave.ArenaWaveMob;
import su.nightexpress.ama.hook.mob.MobProvider;
import su.nightexpress.ama.hook.mob.PluginMobProvider;

public class ArenaWaveManager
implements ArenaChild,
ConfigHolder,
Loadable,
Problematic,
Placeholder {
    public static final String CONFIG_NAME = "waves.yml";
    private final ArenaConfig arenaConfig;
    private final JYML config;
    private final Map<String, ArenaWave> waves;
    private final PlaceholderMap placeholderMap;
    private int finalRound;
    private int firstRoundCountdown;
    private int roundCountdown;
    private boolean gradualSpawnEnabled;
    private double gradualSpawnPercentFirst;
    private int gradualSpawnNextInterval;
    private double gradualSpawnNextPercent;
    private double gradualSpawnNextKillPercent;
    private WaveManagerEditor editor;

    public ArenaWaveManager(@NotNull ArenaConfig arenaConfig) {
        this.arenaConfig = arenaConfig;
        this.config = new JYML(arenaConfig.getFile().getParentFile().getAbsolutePath(), CONFIG_NAME);
        this.waves = new HashMap<String, ArenaWave>();
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems())).add("%arena_waves_delay_first%", () -> NumberUtil.format((double)this.getFirstRoundCountdown())).add("%arena_waves_delay_default%", () -> NumberUtil.format((double)this.getRoundCountdown())).add("%arena_waves_final_wave%", () -> String.valueOf(this.getFinalRound())).add("%arena_waves_gradual_enabled%", () -> LangManager.getBoolean((boolean)this.isGradualSpawnEnabled())).add("%arena_waves_gradual_first_percent%", () -> NumberUtil.format((double)this.getGradualSpawnPercentFirst())).add("%arena_waves_gradual_next_percent%", () -> NumberUtil.format((double)this.getGradualSpawnNextPercent())).add("%arena_waves_gradual_next_interval%", () -> NumberUtil.format((double)this.getGradualSpawnNextInterval())).add("%arena_waves_gradual_next_kill_percent%", () -> NumberUtil.format((double)this.getGradualSpawnNextKillPercent()));
    }

    public void setup() {
        Object object;
        Object object2;
        Object object3;
        String string;
        this.setFinalRound(this.config.getInt("Final_Wave", 100));
        this.setFirstRoundCountdown(this.config.getInt("Delay.First", 5));
        this.setRoundCountdown(this.config.getInt("Delay.Default", 10));
        String string2 = "Gradual_Spawn.";
        this.setGradualSpawnEnabled(this.config.getBoolean(string2 + "Enabled"));
        this.setGradualSpawnPercentFirst(this.config.getDouble(string2 + "First.Amount_Percent", 50.0));
        this.setGradualSpawnNextInterval(this.config.getInt(string2 + "Next.Time_Interval", 5));
        this.setGradualSpawnNextPercent(this.config.getInt(string2 + "Next.Amount_Percent", 20));
        this.setGradualSpawnNextKillPercent(this.config.getInt(string2 + "Next.For_Killed_Percent", 10));
        for (String string3 : this.config.getSection("Amplifiers")) {
            string = "Amplifiers." + string3 + ".";
            int n = this.config.getInt(string + "Values.Amount");
            int n2 = this.config.getInt(string + "Values.Level");
            for (Object object4 : this.config.getSection(string + "Triggers")) {
                object3 = StringUtil.getEnum((String)object4, ArenaGameEventType.class).orElse(null);
                if (object3 == null) continue;
                object2 = "amplifier_" + string3;
                ArenaScript arenaScript = new ArenaScript(this.arenaConfig, (String)object2, (ArenaGameEventType)((Object)object3));
                String string4 = this.config.getString(string + "Triggers." + (String)object4, "");
                Map<String, List<ScriptPreparedCondition>> map = ArenaScript.ofGameTrigger(object3, string4);
                arenaScript.getConditions().putAll(map);
                ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(ScriptActions.ADJUST_MOB_AMOUNT, new ParameterResult());
                scriptPreparedAction.getParameters().add(Parameters.WAVE, "null");
                scriptPreparedAction.getParameters().add(Parameters.AMOUNT, n);
                arenaScript.getActions().add(scriptPreparedAction);
                object = new ScriptPreparedAction(ScriptActions.ADJUST_MOB_LEVEL, new ParameterResult());
                ((ScriptPreparedAction)object).getParameters().add(Parameters.WAVE, "null");
                ((ScriptPreparedAction)object).getParameters().add(Parameters.AMOUNT, n2);
                arenaScript.getActions().add((ScriptPreparedAction)object);
                this.getArenaConfig().getScriptManager().addConverted(arenaScript);
            }
            this.config.remove(string + "Triggers");
        }
        for (String string3 : this.config.getSection("Waves")) {
            string = "Waves." + string3 + ".";
            ArenaWave arenaWave = new ArenaWave(this.arenaConfig, string3, new HashSet<ArenaWaveMob>());
            for (Object object5 : this.config.getSection(string + "Mobs")) {
                Object object4;
                object4 = string + "Mobs." + (String)object5 + ".";
                object3 = PluginMobProvider.getProviders().stream().filter(arg_0 -> ArenaWaveManager.lambda$setup$9((String)object5, arg_0)).findFirst().orElse(null);
                if (object3 == null && (object3 = PluginMobProvider.getProvider((String)(object2 = this.config.getString((String)object4 + "Provider", "AMA")))) == null) {
                    this.plugin().error("Invalid mob provider: '" + (String)object2 + "' in '" + this.getArenaConfig().getId() + " arena.");
                    continue;
                }
                object2 = this.config.getString((String)object4 + "Mob", (String)object5);
                int n = this.config.getInt((String)object4 + "Amount");
                int n3 = this.config.getInt((String)object4 + "Level");
                double d = this.config.getDouble((String)object4 + "Chance");
                object = new ArenaWaveMob(arenaWave, (MobProvider)object3, (String)object2, n, n3, d);
                arenaWave.getMobs().add((ArenaWaveMob)object);
            }
            this.waves.put(arenaWave.getId(), arenaWave);
        }
        this.config.saveChanges();
    }

    public void shutdown() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.waves.values().forEach(ArenaWave::clear);
        this.waves.clear();
    }

    public void onSave() {
        this.config.set("Final_Wave", (Object)this.getFinalRound());
        this.config.set("Delay.First", (Object)this.getFirstRoundCountdown());
        this.config.set("Delay.Default", (Object)this.getRoundCountdown());
        this.config.set("Gradual_Spawn.Enabled", (Object)this.isGradualSpawnEnabled());
        this.config.set("Gradual_Spawn.First.Amount_Percent", (Object)this.getGradualSpawnPercentFirst());
        this.config.set("Gradual_Spawn.Next.Amount_Percent", (Object)this.getGradualSpawnNextPercent());
        this.config.set("Gradual_Spawn.Next.For_Killed_Percent", (Object)this.getGradualSpawnNextKillPercent());
        this.config.set("Gradual_Spawn.Next.Time_Interval", (Object)this.getGradualSpawnNextInterval());
        this.config.remove("Waves");
        this.getWaves().forEach((string, arenaWave) -> {
            String string2 = "Waves." + string + ".";
            arenaWave.getMobs().forEach(arenaWaveMob -> {
                String string2 = string2 + "Mobs." + UUID.randomUUID() + ".";
                this.config.set(string2 + "Provider", (Object)arenaWaveMob.getProvider().getName());
                this.config.set(string2 + "Mob", (Object)arenaWaveMob.getMobId());
                this.config.set(string2 + "Amount", (Object)arenaWaveMob.getAmount());
                this.config.set(string2 + "Level", (Object)arenaWaveMob.getLevel());
                this.config.set(string2 + "Chance", (Object)arenaWaveMob.getChance());
            });
        });
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @NotNull
    public WaveManagerEditor getEditor() {
        if (this.editor == null) {
            this.editor = new WaveManagerEditor(this);
        }
        return this.editor;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public JYML getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getWaves().isEmpty()) {
            arrayList.add(this.problem("No Waves Created!"));
        }
        return arrayList;
    }

    public boolean isInfiniteWaves() {
        return this.getFinalRound() <= 0;
    }

    @NotNull
    public Map<String, ArenaWave> getWaves() {
        return this.waves;
    }

    @Nullable
    public ArenaWave getWave(@NotNull String string) {
        return this.getWaves().get(string.toLowerCase());
    }

    public int getFinalRound() {
        return this.finalRound;
    }

    public void setFinalRound(int n) {
        this.finalRound = n <= 0 ? -1 : n;
    }

    public int getRoundCountdown() {
        return this.roundCountdown;
    }

    public void setRoundCountdown(int n) {
        this.roundCountdown = Math.max(1, n);
    }

    public int getFirstRoundCountdown() {
        return this.firstRoundCountdown;
    }

    public void setFirstRoundCountdown(int n) {
        this.firstRoundCountdown = Math.max(1, n);
    }

    public boolean isGradualSpawnEnabled() {
        return this.gradualSpawnEnabled;
    }

    public void setGradualSpawnEnabled(boolean bl) {
        this.gradualSpawnEnabled = bl;
    }

    public double getGradualSpawnPercentFirst() {
        return this.gradualSpawnPercentFirst;
    }

    public void setGradualSpawnPercentFirst(double d) {
        this.gradualSpawnPercentFirst = d;
    }

    public int getGradualSpawnNextInterval() {
        return this.gradualSpawnNextInterval;
    }

    public void setGradualSpawnNextInterval(int n) {
        this.gradualSpawnNextInterval = n;
    }

    public double getGradualSpawnNextPercent() {
        return this.gradualSpawnNextPercent;
    }

    public void setGradualSpawnNextPercent(double d) {
        this.gradualSpawnNextPercent = Math.min(d, this.getGradualSpawnPercentFirst());
    }

    public double getGradualSpawnNextKillPercent() {
        return this.gradualSpawnNextKillPercent;
    }

    public void setGradualSpawnNextKillPercent(double d) {
        this.gradualSpawnNextKillPercent = Math.min(d, this.getGradualSpawnNextPercent());
    }

    private static /* synthetic */ boolean lambda$setup$9(String string, MobProvider mobProvider) {
        return mobProvider.getMobNames().contains(string);
    }
}

