/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nexmedia.engine.lang.LangManager;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.config.Lang;

public class SetActiveCommand
extends AbstractCommand<AMA> {
    public SetActiveCommand(@NotNull AMA aMA) {
        super((NexPlugin)aMA, new String[]{"setactive"}, (Permission)Perms.COMMAND_SET_ACTIVE);
    }

    @NotNull
    public String getUsage() {
        return ((AMA)this.plugin).getMessage(Lang.COMMAND_SETACTIVE_USAGE).getLocalized();
    }

    @NotNull
    public String getDescription() {
        return ((AMA)this.plugin).getMessage(Lang.COMMAND_SETACTIVE_DESC).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 1) {
            return ((AMA)this.plugin).getArenaManager().getArenaIds();
        }
        if (n == 2) {
            return Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString());
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        if (commandResult.length() < 3) {
            this.printUsage(commandSender);
            return;
        }
        Arena arena = ((AMA)this.plugin).getArenaManager().getArenaById(commandResult.getArg(1));
        if (arena == null) {
            ((AMA)this.plugin).getMessage(Lang.ARENA_ERROR_INVALID).send(commandSender);
            return;
        }
        boolean bl = Boolean.parseBoolean(commandResult.getArg(2));
        arena.getConfig().setActive(bl);
        arena.getConfig().save();
        ((AMA)this.plugin).getMessage(Lang.COMMAND_SETACTIVE_DONE).replace("%state%", (Object)LangManager.getBoolean((boolean)arena.getConfig().isActive())).replace("%arena_id%", (Object)arena.getId()).send(commandSender);
    }
}

