/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.config.Lang;

public class SpectateCommand
extends AbstractCommand<AMA> {
    public SpectateCommand(@NotNull AMA aMA) {
        super((NexPlugin)aMA, new String[]{"spectate"}, (Permission)Perms.COMMAND_SPECTATE);
        this.setDescription(aMA.getMessage(Lang.COMMAND_SPECTATE_DESC));
        this.setUsage(aMA.getMessage(Lang.COMMAND_SPECTATE_USAGE));
        this.setPlayerOnly(true);
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 1) {
            return ((AMA)this.plugin).getArenaManager().getArenas().stream().filter(arena -> arena.getState() == GameState.INGAME && arena.getConfig().getGameplayManager().isSpectateEnabled()).map(Arena::getId).toList();
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        if (commandResult.length() < 2) {
            this.printUsage(commandSender);
            return;
        }
        Arena arena = ((AMA)this.plugin).getArenaManager().getArenaById(commandResult.getArg(1));
        if (arena == null) {
            ((AMA)this.plugin).getMessage(Lang.ARENA_ERROR_INVALID).send(commandSender);
            return;
        }
        Player player = (Player)commandSender;
        arena.joinSpectate(player);
    }
}

