/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.data;

import com.google.gson.reflect.TypeToken;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.data.AbstractUserDataHandler;
import su.nexmedia.engine.api.data.UserDataHolder;
import su.nexmedia.engine.api.data.sql.SQLColumn;
import su.nexmedia.engine.api.data.sql.SQLValue;
import su.nexmedia.engine.api.data.sql.column.ColumnType;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.stats.object.StatType;

public class DataHandler
extends AbstractUserDataHandler<AMA, ArenaUser> {
    private static final SQLColumn COLUMN_COINS = SQLColumn.of((String)"coins", (ColumnType)ColumnType.INTEGER);
    private static final SQLColumn COLUMN_KITS = SQLColumn.of((String)"kits", (ColumnType)ColumnType.STRING);
    private static final SQLColumn COLUMN_STATS = SQLColumn.of((String)"stats", (ColumnType)ColumnType.STRING);
    private static DataHandler instance;
    private final Function<ResultSet, ArenaUser> userFunction = resultSet -> {
        try {
            UUID uUID = UUID.fromString(resultSet.getString(COLUMN_USER_ID.getName()));
            String string = resultSet.getString(COLUMN_USER_NAME.getName());
            long l = resultSet.getLong(COLUMN_USER_DATE_CREATED.getName());
            long l2 = resultSet.getLong(COLUMN_USER_LAST_ONLINE.getName());
            int n = resultSet.getInt(COLUMN_COINS.getName());
            Set set = (Set)this.gson.fromJson(resultSet.getString(COLUMN_KITS.getName()), new TypeToken<Set<String>>(){}.getType());
            Map map = (Map)this.gson.fromJson(resultSet.getString(COLUMN_STATS.getName()), new TypeToken<Map<String, Map<StatType, Integer>>>(){}.getType());
            return new ArenaUser(aMA, uUID, string, l, l2, n, set, map);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    };

    protected DataHandler(@NotNull AMA aMA) {
        super((NexPlugin)aMA, (UserDataHolder)aMA);
    }

    @NotNull
    public static synchronized DataHandler getInstance(@NotNull AMA aMA) {
        if (instance == null) {
            instance = new DataHandler(aMA);
        }
        return instance;
    }

    protected void onShutdown() {
        super.onShutdown();
        instance = null;
    }

    public void onSynchronize() {
    }

    @NotNull
    protected List<SQLColumn> getExtraColumns() {
        return Arrays.asList(COLUMN_COINS, COLUMN_KITS, COLUMN_STATS);
    }

    @NotNull
    protected List<SQLValue> getSaveColumns(@NotNull ArenaUser arenaUser) {
        return Arrays.asList(COLUMN_COINS.toValue((Object)arenaUser.getCoins()), COLUMN_KITS.toValue((Object)this.gson.toJson(arenaUser.getKits())), COLUMN_STATS.toValue((Object)this.gson.toJson(arenaUser.getStats())));
    }

    @NotNull
    protected Function<ResultSet, ArenaUser> getFunctionToUser() {
        return this.userFunction;
    }
}

