/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.data.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.data.AbstractUser;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.stats.object.StatType;

public class ArenaUser
extends AbstractUser<AMA> {
    private int coins;
    private Set<String> kits;
    private Map<String, Map<StatType, Integer>> stats;

    public ArenaUser(@NotNull AMA aMA, @NotNull UUID uUID, @NotNull String string) {
        this(aMA, uUID, string, System.currentTimeMillis(), System.currentTimeMillis(), 0, new HashSet<String>(), new HashMap<String, Map<StatType, Integer>>());
    }

    public ArenaUser(@NotNull AMA aMA, @NotNull UUID uUID, @NotNull String string, long l, long l2, int n, @NotNull Set<String> set, @NotNull Map<String, Map<StatType, Integer>> map) {
        super((NexPlugin)aMA, uUID, string, l, l2);
        this.setCoins(n);
        this.setKits(set);
        this.setStats(map);
    }

    public int getCoins() {
        return this.coins;
    }

    public void setCoins(int n) {
        this.coins = Math.max(0, n);
    }

    public void takeCoins(int n) {
        this.setCoins(this.getCoins() - n);
    }

    public void addCoins(int n) {
        this.setCoins(this.getCoins() + n);
    }

    @NotNull
    public Set<String> getKits() {
        return this.kits;
    }

    public void setKits(@NotNull Set<String> set) {
        this.kits = set;
    }

    public boolean addKit(@NotNull Kit kit) {
        return this.addKit(kit.getId());
    }

    public boolean addKit(@NotNull String string) {
        return this.kits.add(string.toLowerCase());
    }

    public boolean hasKit(@NotNull Kit kit) {
        return this.hasKit(kit.getId());
    }

    public boolean hasKit(@NotNull String string) {
        return this.kits.contains(string.toLowerCase());
    }

    @NotNull
    public Map<String, Map<StatType, Integer>> getStats() {
        return this.stats;
    }

    @NotNull
    public Map<StatType, Integer> getStats(@NotNull String string2) {
        return this.stats.computeIfAbsent(string2.toLowerCase(), string -> new HashMap());
    }

    public int getStats(@NotNull StatType statType) {
        return this.getStats(statType, null);
    }

    public int getStats(@NotNull StatType statType2, @Nullable String string) {
        if (string != null) {
            return this.getStats(string).computeIfAbsent(statType2, statType -> 0);
        }
        int n = 0;
        for (Map<StatType, Integer> map : this.stats.values()) {
            n += map.computeIfAbsent(statType2, statType -> 0).intValue();
        }
        return n;
    }

    public void setStats(@NotNull Map<String, Map<StatType, Integer>> map) {
        this.stats = map;
    }
}

