/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.editor;

import su.nexmedia.engine.api.editor.EditorLocale;

public class EditorLocales
extends su.nexmedia.engine.api.editor.EditorLocales {
    private static final String PREFIX_OLD = "Editor.ArenaEditorType.";
    private static final String PREFIX = "Editor.";
    public static final EditorLocale ARENA_EDITOR = EditorLocales.builder((String)"Editor.ArenaEditorType.EDITOR_ARENA").name("Arena Editor").text(new String[]{"Create and manage your arenas here!"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale KIT_EDITOR = EditorLocales.builder((String)"Editor.ArenaEditorType.EDITOR_KITS").name("Kit Editor").text(new String[]{"Create and manage your kits here!"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale MOB_EDITOR = EditorLocales.builder((String)"Editor.ArenaEditorType.EDITOR_MOBS").name("Mob Editor").text(new String[]{"Create and manage your mobs here!"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OBJECT").name("%arena_name%#d4d9d8 (ID: &f%arena_id%#d4d9d8)").current("Enabled", "%arena_active%").breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Edit").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale ARENA_CREATION = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_CREATE").name("Create Arena").build();
    public static final EditorLocale ARENA_ACTIVE = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_CHANGE_ACTIVE").name("Is Active").text(new String[]{"Sets whether or nor arena", "is enabled for players."}).breakLine().currentHeader().current("Enabled", "%arena_active%").breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale ARENA_NAME = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_CHANGE_NAME").name("Arena Display Name").text(new String[]{"Sets the arena display name.", "It's used in messages, GUIs, holograms, etc."}).breakLine().currentHeader().current("Name", "%arena_name%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale ARENA_SETUP_KIT = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_SETUP_KIT").name("Setup Kit").text(new String[]{"A set of tools to setup arena location."}).breakLine().actionsHeader().action("Left-Click", "Get").build();
    public static final EditorLocale ARENA_AUTO_STATE_SCHEDULERS = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_AUTO_STATE_SCHEDULERS").name("Auto State Schedulers").text(new String[]{"This setting allows you to setup", "automatic arena opening/closing", "at certain day times."}).breakLine().currentHeader().current("Open Times", "").text(new String[]{"%arena_auto_state_open_times%"}).current("Close Times", "").text(new String[]{"%arena_auto_state_close_times%"}).breakLine().actionsHeader().action("Left-Click", "Add Open Time").action("Right-Click", "Add Close Time").action("Shift-Left", "Clear Open Times").action("Shift-Right", "Clear Close Times").build();
    public static final EditorLocale ARENA_GAMEPLAY_MANAGER = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OPEN_GAMEPLAY_MANAGER").name("Gameplay Manager").text(new String[]{"A set of various gameplay features and options."}).breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_WAVE_MANAGER = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OPEN_WAVE_MANAGER").name("Wave Manager").text(new String[]{"Here you predefine mob groups", "to be spawned during the game."}).breakLine().noteHeader().text(new String[]{"You have to create #fdba5escript(s)#d4d9d8 to", "spawn your mobs!"}).breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_REGION_MANAGER = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OPEN_REGION_MANAGER").name("Region Manager").text(new String[]{"Here you predefine arena regions where", "players will fight against mobs."}).breakLine().noteHeader().text(new String[]{"You have to create #fdba5escript(s)#d4d9d8 to", "lock or unlock regions!"}).breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_REWARD_MANAGER = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OPEN_REWARD_MANAGER").name("Reward Manager").text(new String[]{"Here you predefine arena rewards that", "can be given during the game to players."}).breakLine().noteHeader().text(new String[]{"You have to create #fdba5escript(s)#d4d9d8 to", "give rewards to players!"}).breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_SUPPLY_MANAGER = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OPEN_SUPPLY_MANAGER").name("Supply Manager").text(new String[]{"Here you predefine arena chests that", "can be used to generate items in."}).breakLine().noteHeader().text(new String[]{"You have to create #fdba5escript(s)#d4d9d8 to", "refill supply chests!"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_SCRIPT_MANAGER = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OPEN_SCRIPT_MANAGER").name("Script Manager").text(new String[]{"Here you create scripts for all", "the arena aspects and mechanics."}).text(new String[]{"Without them you arena will be unplayable."}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_SHOP_MANAGER = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OPEN_SHOP_MANAGER").name("Shop Manager").text(new String[]{"Arena in-game shop.", "Allows players to purchase items", "during the game."}).breakLine().noteHeader().text(new String[]{"You have to create #fdba5escript(s)#d4d9d8 to", "lock or unlock shop items!"}).breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_SPOT_MANAGER = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_OPEN_SPOT_MANAGER").name("Spot Manager").text(new String[]{"Here you can create special zones,", "that will be changed during the game", "It could be openable doors or gates,", "landscape changing, etc."}).breakLine().noteHeader().text(new String[]{"You have to create #fdba5escript(s)#d4d9d8 to", "activate your spots!"}).breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale ARENA_PERMISSION_REQUIREMENT = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_CHANGE_REQUIREMENT_PERMISSION").name("Permission Requirement(s)").text(new String[]{"Sets whether or not permission", "is required to join the arena."}).breakLine().currentHeader().current("Enabled", "%arena_requirement_permission%").current("Node", "%arena_permission%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale ARENA_PAYMENT_REQUIREMENT = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_CHANGE_REQUIREMENT_PAYMENT").name("Payment Requirement").text(new String[]{"Makes players to pay", "in order to join the arena."}).breakLine().currentHeader().text(new String[]{"%arena_requirement_payment%"}).breakLine().actionsHeader().action("Left-Click", "Add/Change").action("Right-Click", "Clear/Disable").build();
    public static final EditorLocale ARENA_LEVEL_REQUIREMENT = EditorLocales.builder((String)"Editor.ArenaEditorType.ARENA_CHANGE_REQUIREMENT_LEVEL").name("Level Requirement(s)").text(new String[]{"Sets level requirements to join the arena."}).breakLine().currentHeader().text(new String[]{"%arena_requirement_level%"}).breakLine().noteHeader().notes(new String[]{"Supported plugins:", "&fMMOCore"}).breakLine().actionsHeader().action("Left-Click", "Add/Change").action("Right-Click", "Clear/Disable").build();
    public static final EditorLocale REGION_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.REGION_OBJECT").name("%region_name%#d4d9d8 (&f%region_id%#d4d9d8)").text(new String[]{"Enabled: &f%region_active%", "Is Default: &f%region_default%"}).breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Edit").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale REGION_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.REGION_CREATE").name("Create Region").build();
    public static final EditorLocale REGION_SETUP_KIT = EditorLocales.builder((String)"Editor.ArenaEditorType.REGION_SETUP_KIT").name("Setup Kit").text(new String[]{"A set of tools to setup", "region playground."}).breakLine().actionsHeader().action("Left-Click", "Get").build();
    public static final EditorLocale REGION_ACTIVE = EditorLocales.builder((String)"Editor.ArenaEditorType.REGION_CHANGE_ACTIVE").name("Is Active").text(new String[]{"Enable/Disable region."}).breakLine().currentHeader().current("Enabled", "%region_active%").breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale REGION_DEFAULT = EditorLocales.builder((String)"Editor.ArenaEditorType.REGION_CHANGE_DEFAULT").name("Is Default").text(new String[]{"Sets whether or not this region", "is default arena region.", "", "Default region is the first place,", "where players will be spawned."}).breakLine().currentHeader().current("Default", "%region_default%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale REGION_NAME = EditorLocales.builder((String)"Editor.ArenaEditorType.REGION_CHANGE_NAME").name("Display Name").text(new String[]{"Sets region display name.", "It's used in messages, GUIs and holograms."}).breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale GAMEPLAY_TIMELEFT = EditorLocales.builder((String)"Editor.Arena.Gameplay.Timeleft").name("Timeleft").text(new String[]{"Amount of time players have to", "finish the arena until it", "auto-ends as lose."}).breakLine().currentHeader().current("Timeleft", "%gameplay_timeleft% min.").breakLine().actionsHeader().action("Left-Click", "Edit").action("[Q/Drop] Key", "Disable").build();
    public static final EditorLocale GAMEPLAY_LOBBY_COUNTDOWN = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_LOBBY_TIME").name("Lobby Countdown").text(new String[]{"Amount of time players have to", "prepare before arena game starts."}).breakLine().currentHeader().current("Countdown", "%gameplay_lobby_time% sec.").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale GAMEPLAY_ANNOUNCEMENTS = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_ANNOUNCES").name("Start/End Announcements").text(new String[]{"Enables server-wide announcements when", "arena is about to start/end."}).breakLine().currentHeader().current("Enabled", "%gameplay_announcements%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale GAMEPLAY_SCOREBOARD = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_SCOREBOARD").name("Scoreboard").text(new String[]{"Sets whether or not", "scoreboard is enabled.", "", "You can create multiple scoreboards", "in the main config."}).breakLine().currentHeader().current("Enabled", "%gameplay_scoreboard_enabled%").current("Scoreboard", "%gameplay_scoreboard_id%").breakLine().warningHeader().warning(new String[]{"ProtocolLib required!"}).breakLine().actionsHeader().action("Left-Click", "Toggle").action("Right-Click", "Change Scorebaord").build();
    public static final EditorLocale GAMEPLAY_HUNGER = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_HUNGER").name("Natural Hunger").text(new String[]{"Sets whether or not", "natural hunger is enabled."}).breakLine().currentHeader().current("Enabled", "%gameplay_hunger_enabled%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale GAMEPLAY_REGENERATION = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_REGENERATION").name("Natural Regeneration").text(new String[]{"Sets whether or not", "natural regeneration is enabled"}).breakLine().currentHeader().current("Enabled", "%gameplay_regeneration_enabled%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    @Deprecated
    public static final EditorLocale GAMEPLAY_ITEM_SETTINGS = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_ITEM").name("Item Settings").text(new String[]{"Sets whether or not:", "- Item pickup is enabled", "- Item drop is enabled", "- Item durability is enabled."}).breakLine().currentHeader().current("Pickup Enabled", "%gameplay_item_pickup_enabled%").current("Drop Enabled", "%gameplay_item_drop_enabled%").current("Durability Enabled", "%gameplay_item_durability_enabled%").breakLine().actionsHeader().action("Left-Click", "Toggle Drop").action("Right-Click", "Toggle Pickup").action("Shift-Left", "Toggle Durability").build();
    public static final EditorLocale GAMEPLAY_MOB_HIGHLIGHT = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_MOB_HIGHLIGHT").name("Mob Highlighting").text(new String[]{"Sets whether or not", "mob highlighting is enabled when", "amount (%) of mobs is less or equal", "to specified value."}).breakLine().currentHeader().current("Enabled", "%gameplay_mob_highlight_enabled%").current("Amount", "<= %gameplay_mob_highlight_amount%%").current("Color", "%gameplay_mob_highlight_color%").breakLine().noteHeader().text(new String[]{"Due to game limitations,", "set of colors is limited and", "can not be really customized."}).breakLine().actionsHeader().action("Left-Click", "Toggle").action("Right-Click", "Change Amount").action("Shift-Left", "Toggle Color").build();
    public static final EditorLocale GAMEPLAY_MOB_LOOT = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_MOB_DROP").name("Mob Loot").text(new String[]{"Sets whether or not", "mobs will drop items & xp."}).breakLine().currentHeader().current("Drop Items", "%gameplay_mob_drop_items%").current("Drop XP", "%gameplay_mob_drop_exp%").breakLine().actionsHeader().action("Left-Click", "Toggle Items").action("Right-Click", "Toggle XP").build();
    public static final EditorLocale GAMEPLAY_BANNED_ITEMS = EditorLocales.builder((String)"Editor.Arena.Gameplay.BannedItems").name("Banned Items").text(new String[]{"A list of items that can not", "be used on the arena."}).breakLine().currentHeader().text(new String[]{"%gameplay_banned_items%"}).breakLine().noteHeader().text(new String[]{"This option is only useful", "when kits are disabled."}).breakLine().actionsHeader().action("Left-Click", "Add Item").action("[Q/Drop] Key", "Clear List").build();
    public static final EditorLocale GAMEPLAY_ALLOWED_SPAWN_REASONS = EditorLocales.builder((String)"Editor.Arena.Gameplay.SpawnReasons").name("Allowed Spawn Reasons").text(new String[]{"A list of spawn reasons that are", "allowed to spawn mobs inside arena.", ""}).text(new String[]{"This might be useful for", "integration with other plugins."}).breakLine().currentHeader().text(new String[]{"%gameplay_allowed_spawn_reasons%"}).breakLine().actionsHeader().action("Left-Click", "Add Reason").action("[Q/Drop] Key", "Clear List").build();
    public static final EditorLocale GAMEPLAY_PLAYER_AMOUNT = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_PLAYERS_AMOUNT").name("Player Amount").text(new String[]{"Sets how many players can", "join arena at the same time.", "And how many players required", "for the game start."}).breakLine().currentHeader().current("Min", "%gameplay_players_amount_min%").current("Max", "%gameplay_players_amount_max%").breakLine().actionsHeader().action("Left-Click", "Change Min").action("Right-Click", "Change Max").build();
    public static final EditorLocale GAMEPLAY_PLAYER_LIFES = EditorLocales.builder((String)"Editor.Arena.Gameplay.PlayerLifes").name("Player Lifes").text(new String[]{"Sets how many lifes players", "will have on game start.", "And how many time player"}).text(new String[]{"will have to wait until", "being auto-revived."}).breakLine().currentHeader().current("Lifes", "%gameplay_player_lifes_amount%").current("Auto-Revive", "%gameplay_player_revive_time%").breakLine().noteHeader().notes(new String[]{"Set #fdba5eLifes#d4d9d8 to #fdba5e1#d4d9d8 to disable."}).notes(new String[]{"Set #fdba5eAuto-Revive#d4d9d8 to #fdba5e-1#d4d9d8 to revive on round end."}).actionsHeader().action("Left-Click", "Change Lifes").action("Right-Click", "Change Time").build();
    public static final EditorLocale GAMEPLAY_KEEP_INVENTORY = EditorLocales.builder((String)"Editor.Arena.Gameplay.KeepInventory").name("Keep Inventory").text(new String[]{"Sets whether or not", "players will drop items", "on death."}).breakLine().currentHeader().current("Enabled", "%gameplay_keep_inventory%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale GAMEPLAY_SPECTATE = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_SPECTATE").name("Spectate Allowed").text(new String[]{"Sets whether or not", "non-arena players can spectate", "this arena."}).breakLine().currentHeader().current("Enabled", "%gameplay_spectate_enabled%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale GAMEPLAY_COMMANDS = EditorLocales.builder((String)"Editor.Arena.Gameplay.Commands").name("Commands Allowed").text(new String[]{"Sets whether or not", "non-arena commands are allowed."}).breakLine().currentHeader().current("Enabled", "%gameplay_command_usage_enabled%").current("Whitelist", "").text(new String[]{"%gameplay_command_usage_whitelist%"}).breakLine().actionsHeader().action("Left-Click", "Toggle").action("Right-Click", "Add Whitelisted").action("[Q/Drop] Key", "Clear List").build();
    public static final EditorLocale GAMEPLAY_KITS = EditorLocales.builder((String)"Editor.Arena.Gameplay.Kits").name("Kits Allowed").text(new String[]{"Sets whether or not", "kits are allowed to use."}).breakLine().currentHeader().current("Enabled", "%gameplay_kits_enabled%").current("Allowed", "").text(new String[]{"%gameplay_kits_allowed%"}).breakLine().actionsHeader().action("Left-Click", "Toggle").action("Right-Click", "Add Allowed").action("[Q/Drop] Key", "Clear List").build();
    public static final EditorLocale GAMEPLAY_KIT_LIMITS = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_KITS_LIMITS").name("Kits Limits").text(new String[]{"Sets how many players", "can use certain kit(s)", "at the same time."}).breakLine().currentHeader().text(new String[]{"%gameplay_kits_limits%"}).breakLine().actionsHeader().action("Left-Click", "Add Limit").action("[Q/Drop] Key", "Clear List").build();
    public static final EditorLocale GAMEPLAY_PETS = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_PETS_ALLOWED").name("Pets Allowed").text(new String[]{"Sets whether or not", "player pets are allowed."}).breakLine().currentHeader().current("Enabled", "%gameplay_pets_allowed%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale GAMEPLAY_MCMMO = EditorLocales.builder((String)"Editor.ArenaEditorType.GAMEPLAY_CHANGE_MCMMO_ALLOWED").name("mcMMO Allowed").text(new String[]{"Sets whether or not", "players can use mcMMO abilities."}).breakLine().currentHeader().current("Enabled", "%gameplay_mcmmo_allowed%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale WAVES_ROUND_INTERVAL = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_DELAY").name("Round Interval").text(new String[]{"Sets the countdown before new round.", ""}).text(new String[]{"Countdown will start only when", "all mobs from current round are killed."}).breakLine().currentHeader().current("First Round", "%arena_waves_delay_first% sec.").current("All Other", "%arena_waves_delay_default% sec.").breakLine().actionsHeader().action("Left-Click", "Change First").action("Right-Click", "Change Other").build();
    public static final EditorLocale WAVES_FINAL_ROUND = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_FINAL_WAVE").name("Final Round").text(new String[]{"Sets which round will be final.", ""}).text(new String[]{"When final round is completed,", "game ends as victory.", ""}).text(new String[]{"If final round is disabled,", "game will continue until", "all players are dead."}).breakLine().currentHeader().current("Final Round", "%arena_waves_final_wave%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale WAVES_WAVES = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_WAVES").name("Waves").text(new String[]{"Here you predefine waves", "aka mob groups that will be", "spawned during the game by", "arena scripts"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale WAVES_GRADUAL = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_GRADUAL").name("Gradual Spawning").text(new String[]{"This features allows you to configure", "mobs spawn that way so they will", "spawn by small groups"}).text(new String[]{"during the round instead of", "spawn all together at round start."}).breakLine().currentHeader().current("Enabled", "%arena_waves_gradual_enabled%").breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale WAVES_GRADUAL_ENABLED = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_GRADUAL_ENABLED").name("Enabled").text(new String[]{"Sets whether or not", "gradual spawning feature is enabled."}).breakLine().currentHeader().current("Enabled", "%arena_waves_gradual_enabled%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale WAVES_GRADUAL_FIRST_PERCENT = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_GRADUAL_FIRST_PERCENT").name("First Group Amount (%)").text(new String[]{"Sets how many mobs (%) of total", "amount will be spawned on", "round start."}).breakLine().currentHeader().current("Amount", "%arena_waves_gradual_first_percent%%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale WAVES_GRADUAL_NEXT_PERCENT = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_GRADUAL_NEXT_PERCENT").name("Next Group Amount (%)").text(new String[]{"Sets how many mobs (%) of total", "amount will be spawned during", "the round."}).breakLine().currentHeader().current("Amount", "%arena_waves_gradual_next_percent%%").breakLine().warningHeader().warning(new String[]{"Can not exceed #fd5e5eFirst Group Amount"}).breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale WAVES_GRADUAL_NEXT_INTERVAL = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_GRADUAL_NEXT_INTERVAL").name("Next Group Interval").text(new String[]{"Sets how often (in seconds)", "arena will attempt to spawn another", "group of mobs."}).breakLine().currentHeader().current("Interval", "%arena_waves_gradual_next_interval% sec.").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale WAVES_GRADUAL_NEXT_KILL_PERCENT = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_CHANGE_GRADUAL_NEXT_KILL_PERCENT").name("Next Group for Killed Amount").text(new String[]{"Sets how many mobs (%) of total", "amount must be killed to prepare", "new mob group to spawn.", ""}).text(new String[]{"Set this to 0 to spawn mobs", "using the #fdf35eNext Group Interval#d4d9d8 only."}).breakLine().currentHeader().current("Amount", "%arena_waves_gradual_next_kill_percent%%").breakLine().warningHeader().warning(new String[]{"Can not exceed #fd5e5eNext Group Amount"}).breakLine().actionsHeader().action("Left-Click", "Change").breakLine().build();
    public static final EditorLocale WAVES_WAVE_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_WAVE_OBJECT").name("Wave: #5e9dfd%arena_wave_id%").text(new String[]{"Mobs:"}).text(new String[]{"%arena_wave_mobs%"}).breakLine().actionsHeader().action("Left-Click", "Edit").action("Shift-Right", "Delete#fd5e5e (No Undo)").build();
    public static final EditorLocale WAVES_WAVE_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_WAVE_CREATE").name("Create Wave").build();
    public static final EditorLocale WAVES_WAVE_MOB_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_WAVE_MOB_OBJECT").name("Mob: #5e9dfd%arena_wave_mob_id%").current("Provider", "%arena_wave_mob_provider%").current("Start Amount", "%arena_wave_mob_amount%").current("Start Level", "%arena_wave_mob_level%").current("Spawn Chance", "%arena_wave_mob_chance%").breakLine().noteHeader().notes(new String[]{"Level & amount can be adjusted with scripts."}).actionsHeader().action("Left-Click", "Change Mob Type").action("Right-Click", "Change Amount").action("[Q/Drop] Key", "Change Chance").action("[F/Swap] Key", "Change Provider").action("Shift-Right", "Delete#fd5e5e (No Undo)").build();
    public static final EditorLocale WAVES_WAVE_MOB_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.WAVES_WAVE_MOB_CREATE").name("Add Mob").text(new String[]{"Adds an empty mob configuration."}).build();
    public static final EditorLocale SUPPLY_CHEST_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SUPPLY_CHEST_CREATE").name("Create Supply Chest").build();
    public static final EditorLocale SUPPLY_CHEST_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SUPPLY_CHEST_OBJECT").name("Supply Chest &7(ID: &f%supply_chest_id&7)").current("Location", "%supply_chest_location_x%, %supply_chest_location_y%, %supply_chest_location_z%#d4d9d8 in #fdf35e%supply_chest_location_world%").breakLine().actionsHeader().action("Left-Click", "Edit").action("Right-Click", "Teleport").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SUPPLY_CHEST_ITEMS = EditorLocales.builder((String)"Editor.ArenaEditorType.SUPPLY_CHEST_CHANGE_ITEMS").name("Content").text(new String[]{"Here you can add items that", "will be used to (re)fill this chest.", ""}).text(new String[]{"Put items in opened menu and close it", "to return back here."}).breakLine().actionsHeader().action("Left-Click", "Open").build();
    public static final EditorLocale SUPPLY_CHEST_REFILL_AMOUNT = EditorLocales.builder((String)"Editor.ArenaEditorType.SUPPLY_CHEST_CHANGE_REFILL_AMOUNT").name("Item Refill Amount").text(new String[]{"Sets how many items will be", "added to the chest on refill."}).breakLine().currentHeader().current("Min", "%supply_chest_refill_items_min%").current("Max", "%supply_chest_refill_items_max%").breakLine().noteHeader().text(new String[]{"On each refill previous items", "are removed!"}).breakLine().actionsHeader().action("Left-Click", "Change Min").action("Right-Click", "Change Max").build();
    public static final EditorLocale SUPPLY_CHEST_LOCATION = EditorLocales.builder((String)"Editor.ArenaEditorType.SUPPLY_CHEST_CHANGE_LOCATION").name("Location").text(new String[]{"Sets the supply chest location."}).breakLine().currentHeader().current("Location", "%supply_chest_location_x%, %supply_chest_location_y%, %supply_chest_location_z% in %supply_chest_location_world%").breakLine().noteHeader().text(new String[]{"Left click a chest/container to", "assign it with supply chest."}).breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale REWARDS_RETAIN = EditorLocales.builder((String)"Editor.ArenaEditorType.REWARDS_CHANGE_RETAIN").name("Retain Settings").text(new String[]{"Sets whether or not rewards obtained during", "the game will be saved when player", "dies or leaves the arena before", "final round."}).breakLine().currentHeader().current("On Death", "%reward_manager_retain_on_death%").current("On Leave", "%reward_manager_retain_on_leave%").breakLine().noteHeader().text(new String[]{"This setting will have effect on 'Late' rewards only."}).breakLine().actionsHeader().action("Left-Click", "Toggle Death").action("Right-Click", "Toggle Leave").build();
    public static final EditorLocale REWARD_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.REWARD_OBJECT").name("%reward_name%#d4d9d8 (ID: &f%reward_id%#d4d9d8)").actionsHeader().action("Left-Click", "Edit").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale REWARD_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.REWARD_CREATE").name("Create Reward").build();
    public static final EditorLocale REWARD_NAME = EditorLocales.builder((String)"Editor.ArenaEditorType.REWARD_CHANGE_NAME").name("Display Name").text(new String[]{"Name used in messages, GUIs, holograms."}).breakLine().currentHeader().current("Name", "%reward_name%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale REWARD_LATE = EditorLocales.builder((String)"Editor.ArenaEditorType.REWARD_CHANGE_LATE").name("Is Late").text(new String[]{"Sets whether or not", "reward will be given on game end", "or immediately."}).breakLine().currentHeader().current("Enabled", "%reward_is_late%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale REWARD_COMMANDS = EditorLocales.builder((String)"Editor.ArenaEditorType.REWARD_CHANGE_COMMANDS").name("Commands").text(new String[]{"Commands to execute when player", "obtains this reward."}).breakLine().currentHeader().text(new String[]{"%reward_commands%"}).breakLine().actionsHeader().action("Left-Click", "Add Command").action("Right-Click", "Clear List").build();
    public static final EditorLocale REWARD_ITEMS = EditorLocales.builder((String)"Editor.ArenaEditorType.REWARD_CHANGE_ITEMS").name("Items").text(new String[]{"Items to give when player", "obtains this reward."}).breakLine().actionsHeader().action("Left-Click", "Open").build();
    public static final EditorLocale SHOP_CATEGORIES = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_OPEN_CATEGORIES").name("Categories").text(new String[]{"Here you can create and", "manage shop categories"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale SHOP_ACTIVE = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CHANGE_ACTIVE").name("Active").text(new String[]{"Sets whether or not", "shop is enabled for arena."}).breakLine().currentHeader().current("Enabled", "%shop_manager_is_active%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale SHOP_HIDE_OTHER_KIT_ITEMS = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CHANGE_HIDE_OTHER_KIT_ITEMS").name("Hide Other Kit Items").text(new String[]{"Sets whether or not", "items requires certain kit(s)", "will be hidden for players", "without that kits."}).breakLine().currentHeader().current("Enabled", "%shop_manager_hide_other_kit_items%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale SHOP_CATEGORY_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CATEGORY_OBJECT").name("%shop_category_name%#d4d9d8 (ID: &f%shop_category_id%#d4d9d8)").actionsHeader().action("Left-Click", "Change").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SHOP_CATEGORY_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CATEGORY_CREATE").name("Create Category").build();
    public static final EditorLocale SHOP_CATEGORY_NAME = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CATEGORY_CHANGE_NAME").name("Display Name").text(new String[]{"Sets category display name.", "It's used in messages, GUIs, holograms, etc."}).breakLine().currentHeader().current("Name", "%shop_category_name%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale SHOP_CATEGORY_DESCRIPTION = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CATEGORY_CHANGE_DESCRIPTION").name("Category Description").text(new String[]{"Sets category description.", "It's used in GUIs, holograms, etc."}).breakLine().currentHeader().text(new String[]{"%shop_category_description%"}).breakLine().actionsHeader().action("Left-Click", "Add Line").action("Right-Click", "Clear").build();
    public static final EditorLocale SHOP_CATEGORY_ICON = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CATEGORY_CHANGE_ICON").name("Icon").text(new String[]{"Sets icon for the category", "to be displayed in shop GUIs."}).breakLine().actionsHeader().action("Drag & Drop", "Replace").build();
    public static final EditorLocale SHOP_CATEGORY_ALLOWED_KITS = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CATEGORY_CHANGE_ALLOWED_KITS").name("Allowed Kits").text(new String[]{"A list of kits which can", "access the category."}).breakLine().currentHeader().text(new String[]{"%shop_category_allowed_kits%"}).breakLine().noteHeader().text(new String[]{"If no kits are set, then anyone can access the category."}).breakLine().actionsHeader().action("Left-Click", "Add Kit").action("Right-Click", "Clear List").build();
    public static final EditorLocale SHOP_CATEGORY_PRODUCTS = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_CATEGORY_CHANGE_PRODUCTS").name("Products").text(new String[]{"Here you can create and configure", "category products."}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale SHOP_PRODUCT_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_OBJECT").name("%shop_product_name%#d4d9d8 (ID: &f%shop_product_id%#d4d9d8)").current("Price", "%shop_product_price%").breakLine().actionsHeader().action("Left-Click", "Edit").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SHOP_PRODUCT_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CREATE").name("Create Product").build();
    public static final EditorLocale SHOP_PRODUCT_NAME = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CHANGE_NAME").name("Display Name").text(new String[]{"Sets product display name.", "It's used in messages, GUIs, holograms, etc."}).breakLine().currentHeader().current("Name", "%shop_product_name%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale SHOP_PRODUCT_DESCRIPTION = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CHANGE_DESCRIPTION").name("Description").text(new String[]{"Sets product description.", "It's used in GUIs, holograms, etc."}).breakLine().currentHeader().text(new String[]{"%shop_product_description%"}).breakLine().actionsHeader().action("Left-Click", "Add Line").action("Right-Click", "Clear").build();
    public static final EditorLocale SHOP_PRODUCT_CURRENCY = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CHANGE_CURRENCY").name("Currency").text(new String[]{"Sets product currency."}).breakLine().currentHeader().current("Currency", "%shop_product_currency%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale SHOP_PRODUCT_PRICE = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CHANGE_PRICE").name("Price").text(new String[]{"Sets product price."}).breakLine().currentHeader().current("Price", "%shop_product_price%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale SHOP_PRODUCT_ICON = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CHANGE_ICON").name("Icon").text(new String[]{"Sets product icon.", "It's displayed in GUIs."}).breakLine().actionsHeader().action("Drag & Drop", "Replace").build();
    public static final EditorLocale SHOP_PRODUCT_REQUIRED_KITS = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CHANGE_REQUIRED_KITS").name("Allowed Kits").text(new String[]{"A list of kits which can", "access this product."}).breakLine().currentHeader().text(new String[]{"%shop_product_allowed_kits%"}).breakLine().noteHeader().text(new String[]{"If no kits are set, then anyone can access the product."}).breakLine().actionsHeader().action("Left-Click", "Add Kit").action("Right-Click", "Clear List").build();
    public static final EditorLocale SHOP_PRODUCT_ITEMS = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CHANGE_ITEMS").name("Items").text(new String[]{"Items to give when", "player purchases this product."}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale SHOP_PRODUCT_COMMANDS = EditorLocales.builder((String)"Editor.ArenaEditorType.SHOP_PRODUCT_CHANGE_COMMANDS").name("Commands").text(new String[]{"Commands to execute when", "player purchases this product."}).breakLine().currentHeader().text(new String[]{"%shop_product_commands%"}).breakLine().actionsHeader().action("Left-Click", "Add Command").action("Shift-Right", "Clear List").build();
    public static final EditorLocale SPOT_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SPOT_OBJECT").name("%spot_name%#d4d9d8 (ID: &f%spot_id%#d4d9d8)").current("Active", "%spot_active%").breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Edit").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SPOT_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SPOT_CREATE").name("Create Spot").build();
    public static final EditorLocale SPOT_SETUP_KIT = EditorLocales.builder((String)"Editor.ArenaEditorType.SPOT_SETUP_KIT").name("Setup Kit").text(new String[]{"A set of tools to setup a spot."}).breakLine().actionsHeader().action("Left-Click", "Get").build();
    public static final EditorLocale SPOT_ACTIVE = EditorLocales.builder((String)"Editor.ArenaEditorType.SPOT_CHANGE_ACTIVE").name("Active").text(new String[]{"Sets whether or not", "spot is enabled and active."}).breakLine().currentHeader().current("Enabled", "%spot_active%").breakLine().textRaw(new String[]{"%problems%"}).breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale SPOT_NAME = EditorLocales.builder((String)"Editor.ArenaEditorType.SPOT_CHANGE_NAME").name("Display Name").text(new String[]{"Sets spot display name.", "It's used in messages, GUIs, etc."}).breakLine().currentHeader().current("Name", "%spot_name%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale SPOT_STATES = EditorLocales.builder((String)"Editor.ArenaEditorType.SPOT_CHANGE_STATES").name("States").text(new String[]{"Here you can create and setup", "different spot states."}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale SPOT_STATE_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SPOT_STATE_OBJECT").name("State: #aefd5e%spot_state_id%").text(new String[]{"Simply build something inside", "the spot area and save it."}).breakLine().actionsHeader().action("Left-Click", "Build/Edit").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SPOT_STATE_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SPOT_STATE_CREATE").name("Create State").build();
    public static final EditorLocale SCRIPT_CATEGORY_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SCRIPT_CATEGORY_OBJECT").name("Category: #aefd5e%script_category_id%").actionsHeader().action("Left-Click", "Edit").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SCRIPT_CATEGORY_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SCRIPT_CATEGORY_CREATE").name("Create Category").build();
    public static final EditorLocale SCRIPT_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SCRIPT_OBJECT").name("Script: &6%script_id%").currentHeader().current("Event", "%script_event_type%").current("Conditions", "").text(new String[]{"%script_condition_section_conditions%"}).current("Actions", "").text(new String[]{"%script_action_parameters%"}).breakLine().actionsHeader().action("Left-Click", "Edit Actions").action("Right-Click", "Edit Conditions").action("[Q/Drop] Key", "Toggle Event").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SCRIPT_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SCRIPT_CREATE").name("Create Script").build();
    public static final EditorLocale SCRIPT_ACTION_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SCRIPT_ACTION_OBJECT").name("Action: #aefd5e%script_action_name%").currentHeader().text(new String[]{"%script_action_parameters%"}).breakLine().actionsHeader().action("Left-Click", "Add Parameter").action("Right-Click", "Clear Parameters").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SCRIPT_ACTION_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SCRIPT_ACTION_CREATE").name("Create Action").build();
    public static final EditorLocale SCRIPT_CONDITION_SECTION_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.SCRIPT_CONDITION_SECTION_OBJECT").name("Conditions Section: #aefd5e%script_condition_section_id%").currentHeader().text(new String[]{"%script_condition_section_conditions%"}).breakLine().actionsHeader().action("Left-Click", "Add Condition").action("Right-Click", "Clear Conditions").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale SCRIPT_CONDITION_SECTION_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.SCRIPT_CONDITION_SECTION_CREATE").name("Create Conditions Section").build();
    public static final EditorLocale KIT_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_OBJECT").name("%kit_name%#d4d9d8 (ID: &f%kit_id%#d4d9d8)").current("Is Default", "%kit_is_default%").breakLine().breakLine().actionsHeader().action("Left-Click", "Edit").action("Shift-Right", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale KIT_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CREATE").name("Create Kit").build();
    public static final EditorLocale KIT_NAME = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_NAME").name("Display Name").text(new String[]{"Sets kit display name.", "It's used in messages, GUIs, signs, holograms, etc."}).breakLine().currentHeader().current("Name", "%kit_name%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale KIT_DESCRIPTION = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_DESCRIPTION").name("Description").text(new String[]{"Sets kit description.", "It's used in GUIs, holograms, etc."}).breakLine().currentHeader().text(new String[]{"%kit_description%"}).breakLine().actionsHeader().action("Left-Click", "Add Line").action("Right-Click", "Clear").build();
    public static final EditorLocale KIT_ICON = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_ICON").name("Icon").text(new String[]{"Represents a kit icon used", "in Kit Selector and Kit Shop GUIs."}).breakLine().actionsHeader().action("Drag & Drop", "Replace").action("Right-Click", "Get Copy").build();
    public static final EditorLocale KIT_COMMANDS = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_COMMANDS").name("Commands").text(new String[]{"Commands to execute on game start", "for players selected this kit."}).breakLine().currentHeader().text(new String[]{"%kit_commands%"}).breakLine().actionsHeader().action("Left-Click", "Add Command").action("Right-Click", "Clear List").build();
    public static final EditorLocale KIT_POTIONS = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_POTIONS").name("Potion Effects").text(new String[]{"Potion effects, that will be permanently", "applied to a player."}).breakLine().currentHeader().text(new String[]{"%kit_potion_effects%"}).breakLine().actionsHeader().action("Left-Click", "Add Effect").action("Right-Click", "Clear List").build();
    public static final EditorLocale KIT_ARMOR = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_ARMOR").name("Armor").text(new String[]{"A set of armors that will be", "equipped to a player."}).breakLine().warningHeader().warning(new String[]{"Boots \u2192 Legs \u2192 Chest \u2192 Head \u2192 OffHand"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale KIT_INVENTORY = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_INVENTORY").name("Inventory").text(new String[]{"A list of items that will be", "added to a player's inventory."}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale KIT_PERMISSION = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_PERMISSION").name("Permission Requirement").text(new String[]{"Sets whether or not permission", "is required to use this kit."}).breakLine().currentHeader().current("Enabled", "%kit_is_permission%").current("Node", "%kit_permission%").breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale KIT_COST = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_COST").name("Kit Cost").text(new String[]{"Sets kit cost."}).breakLine().currentHeader().current("Cost", "%kit_cost%").breakLine().noteHeader().text(new String[]{"Set this to 0 to make kit", "available without purchase."}).breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale KIT_DEFAULT = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_DEFAULT").name("Is Default").text(new String[]{"Sets whether or not this kit", "is default kit."}).breakLine().currentHeader().current("Is Default", "%kit_is_default%").breakLine().noteHeader().text(new String[]{"Default kit is used when", "player didn't select kit in lobby."}).breakLine().actionsHeader().action("Left-Click", "Toggle").build();
    public static final EditorLocale KIT_CURRENCY = EditorLocales.builder((String)"Editor.ArenaEditorType.KIT_CHANGE_CURRENCY").name("Currency").text(new String[]{"Sets the currency used to", "purchase this kit."}).breakLine().currentHeader().current("Currency", "%kit_currency%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale MOB_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_OBJECT").name("%mob_name%#d4d9d8 (&f%mob_id%#d4d9d8)").actionsHeader().action("Left-Click", "Edit").action("Right-Click", "Delete #fd5e5e(No Undo)").build();
    public static final EditorLocale MOB_CREATE = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_CREATE").name("Create Mob").build();
    public static final EditorLocale MOB_NAME = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_CHANGE_NAME").name("Display Name").text(new String[]{"Sets mob display name and", "whether or not this name is", "always visible."}).breakLine().currentHeader().current("Name", "%mob_name%").current("Is Visible", "%mob_name_visible%").breakLine().actionsHeader().action("Left-Click", "Change Name").action("Right-Click", "Toggle Visibility").build();
    public static final EditorLocale MOB_ENTITY_TYPE = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_CHANGE_ENTITY_TYPE").name("Entity Type").text(new String[]{"Sets mob entity type."}).breakLine().currentHeader().current("Type", "%mob_entity_type%").breakLine().actionsHeader().action("Left-Click", "Change").build();
    public static final EditorLocale MOB_LEVEL = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_CHANGE_LEVEL").name("Mob Levels").text(new String[]{"Sets mob min. and max. levels."}).breakLine().currentHeader().current("Min", "%mob_level_min%").current("Max", "%mob_level_max%").breakLine().noteHeader().text(new String[]{"Mob level can be adjusted during", "the game with Arena Scripts."}).breakLine().actionsHeader().action("Left-Click", "Edit Min").action("Right-Click", "Edit Max").build();
    public static final EditorLocale MOB_BOSSBAR = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_CHANGE_BOSSBAR").name("Boss Bar").text(new String[]{"Mob health bossbar settings."}).breakLine().currentHeader().current("Enabled", "%mob_bossbar_enabled%").current("Color", "%mob_bossbar_color%").current("Style", "%mob_bossbar_style%").breakLine().actionsHeader().action("Left-Click", "Toggle").action("Shift-Left", "Change Color").action("Shift-Right", "Change Style").build();
    public static final EditorLocale MOB_ATTRIBUTES = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_CHANGE_ATTRIBUTES").name("Mob Attributes").text(new String[]{"Sets mob default and per-level attributes."}).breakLine().currentHeader().current("Base", "").text(new String[]{"%mob_attributes_base%"}).current("Per Level", "").text(new String[]{"%mob_attributes_level%"}).breakLine().noteHeader().text(new String[]{"Base attribute with zero value means", "that default mob's attribute value", "won't be changed."}).breakLine().actionsHeader().action("Left-Click", "Change Base").action("Right-Click", "Change Per-Level").action("Shift-Left", "Clear All").build();
    public static final EditorLocale MOB_EQUIPMENT = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_CHANGE_EQUIPMENT").name("Mob Equipment").text(new String[]{"Items to be equipped on a mob."}).breakLine().warningHeader().warning(new String[]{"Boots \u2192 Legs \u2192 Chest \u2192 Head \u2192 Hand \u2192 Off Hand"}).breakLine().actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale MOB_STYLES = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_CHANGE_STYLES").name("Mob Styles").actionsHeader().action("Left-Click", "Navigate").build();
    public static final EditorLocale MOB_STYLE_OBJECT = EditorLocales.builder((String)"Editor.ArenaEditorType.MOB_STYLE_OBJECT").name("Style Type: #aefd5e%mob_style_type%").currentHeader().current("Value", "%mob_style_value%").breakLine().actionsHeader().action("Left-Click", "Change").action("Right-Click", "Remove").build();
}

