/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.hologram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.api.server.AbstractTask;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.api.hologram.IHologramClick;
import su.nightexpress.ama.api.hologram.IHologramHandler;
import su.nightexpress.ama.api.hologram.IHologramWrapper;
import su.nightexpress.ama.command.hologram.HologramMainCommand;
import su.nightexpress.ama.config.Config;

public class HologramManager
extends AbstractManager<AMA> {
    private final IHologramHandler<?> handler;
    private final Map<HologramType, Map<UUID, IHologramWrapper<?>>> hologramIds;
    private LifeTask lifeTask;

    public HologramManager(@NotNull AMA aMA, @NotNull IHologramHandler<?> iHologramHandler) {
        super((NexPlugin)aMA);
        this.handler = iHologramHandler;
        this.hologramIds = new ConcurrentHashMap();
        DirMctLeUksmXxYhyQckpM3wxEWJVKy.1EjfNFBbuR(Class.forName("DiTectLeaSsnRcxog9aAnPQPPPboQo"));
    }

    protected void onLoad() {
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIREwTlEaWs", "\u0000>]\u0007Q\u000b_'\u0017\u001a*]\fZ\u0014[,\u0016](\u001c\u0004Y\u0012\\&]#'\u0006\u000e]\u001d\u007f#\u001a\u001d\b\u001c\u0004Y\u0012\\&", (Object)"\u0012/\u0017*\\\u001a^&\u0001\u0016%", "[\u0007\u0000\u001c\u001b\u001dW:\u001e\u0016/\u001a\b\u001b\u0016\\%\u001a\u001d.\\\bD\u001a\u001d!\u001c\u001e&\u0012\u0007P\\s \u0000\u00079\u0012\n@0]/\u001e\u0012%\u0017R\u001d%", 77, 0.6109692973157584, "WseS4kUx6Ymc9DswgK9jKdhuCzql3NojJpB0wAB", DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIREwTlEaWs", "\u0012FO\u0007\u0011\u0019_'\u0005\bRO\f\u001a\u0006[,\u0004OP\u000e\u0004\u0019\u0000\\&O\"\\\f\u0004\u0015\u000fV\u000f\u0000\u000fR\u0006\f\u0006", (Object)"\u0006V\u0015$\u0015\b\\\u0001\u000e\f^\u0000\u0007\u0010", "I\u001a-\u001a\u0001N\\'\u0019\fV\u0005\u0000\u0015NW,\u0006\b]\u0004F\u0017\u000e_/\u0000\u000fWN9\u0018\u0014U+\u000f,R\b\u00077\u000e_/\u0000\u000fWZ", 75, 0.6946644007991366, "YalZtME7aVpNElGJC3KKTcLVr7ujKua1iasL", DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIREwTlEaWs", "?8b\u00070+Z6)4=>\f*?\u001c#!-c\r$\u0018", (Object)"+(8*6!_#\"(\u0000-\u00078+W0", "dd\u0000\u001a,c\\'4!((\u00008cW,+%#)F:#_/-\")c*6!_#\"(\u0000-\u00078+W0w", 77, 1.7639451963305983, "PLMQYRRgQPEV348zlMqB7JhIblYjY1jHn2px3", (Object)((AMA)this.plugin))), (Object)new HologramMainCommand((AMA)this.plugin));
        this.lifeTask = new LifeTask((AMA)this.plugin);
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIREwTlEaWs", "K>\u0016\u0007'_Z6]@;J\f=K\u001c#UYeP\u0006\"WU0YUep\u0006\"WU0YU\u0006Y\u0007/_W0\u001ct\"^\f\u001aYA)", (Object)"K?Y\u001b:", "\u0010bb", 77, 0.16505343f, "K8RMNz4pjje7h81rkKdGIhTvd5me4N6NkBm36EE2bbmuoTsvSRSKdZ", (Object)this.lifeTask);
    }

    protected void onShutdown() {
        if (this.lifeTask != null) {
            this.lifeTask.stop();
            this.lifeTask = null;
        }
        ((AMA)this.plugin).getCommandManager().getMainCommand().removeChildren("hologram");
        this.hologramIds.values().forEach(map -> map.values().forEach(IHologramWrapper::delete));
        this.hologramIds.clear();
    }

    @NotNull
    public static List<String> getFormat(@NotNull HologramType hologramType) {
        return new ArrayList<String>(((Map)Config.HOLOGRAMS_FORMAT.get()).getOrDefault((Object)hologramType, Collections.emptyList()));
    }

    @NotNull
    public IHologramHandler<?> getHandler() {
        return this.handler;
    }

    @NotNull
    public Map<UUID, IHologramWrapper<?>> getHolograms(@NotNull HologramType hologramType2) {
        return this.hologramIds.computeIfAbsent(hologramType2, hologramType -> new HashMap());
    }

    @NotNull
    public UUID create(@NotNull HologramType hologramType, @NotNull Location location, @NotNull List<String> list) {
        return this.create(hologramType, location, list, -1);
    }

    @NotNull
    public UUID create(@NotNull Location location, @NotNull List<String> list, int n) {
        return this.create(HologramType.DEFAULT, location, list, n);
    }

    @NotNull
    public UUID create(@NotNull HologramType hologramType, @NotNull Location location, @NotNull List<String> list, int n) {
        Location location2 = location.clone();
        UUID uUID = UUID.randomUUID();
        IHologramWrapper<?> iHologramWrapper = this.getHandler().create(location2, list, n);
        this.getHolograms(hologramType).put(uUID, iHologramWrapper);
        return uUID;
    }

    public void setClick(@NotNull HologramType hologramType, @NotNull UUID uUID, @NotNull IHologramClick iHologramClick) {
        IHologramWrapper<?> iHologramWrapper = this.getHolograms(hologramType).get(uUID);
        if (iHologramWrapper != null) {
            iHologramWrapper.setClick(iHologramClick);
        }
    }

    public void update(@NotNull HologramType hologramType, @NotNull UUID uUID, @NotNull List<String> list) {
        IHologramWrapper<?> iHologramWrapper = this.getHolograms(hologramType).get(uUID);
        if (iHologramWrapper != null) {
            iHologramWrapper.setText(list);
        }
    }

    public void delete(@NotNull HologramType hologramType, @NotNull UUID uUID) {
        IHologramWrapper<?> iHologramWrapper = this.getHolograms(hologramType).remove(uUID);
        if (iHologramWrapper != null) {
            iHologramWrapper.delete();
        }
    }

    class LifeTask
    extends AbstractTask<AMA> {
        public LifeTask(AMA aMA) {
            super((NexPlugin)aMA, 20L, false);
        }

        public void action() {
            for (HologramType hologramType : HologramType.values()) {
                HologramManager.this.getHolograms(hologramType).values().stream().filter(IHologramWrapper::isDead).forEach(IHologramWrapper::delete);
                HologramManager.this.getHolograms(hologramType).values().removeIf(IHologramWrapper::isDead);
            }
        }
    }
}

