/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.hologram.handler;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.TouchableLine;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.api.hologram.IHologramClick;
import su.nightexpress.ama.api.hologram.IHologramHandler;
import su.nightexpress.ama.api.hologram.IHologramWrapper;

public class HologramDisplaysHandler
implements IHologramHandler<Hologram> {
    @Override
    @NotNull
    public IHologramWrapper<Hologram> create(@NotNull Location location, @NotNull List<String> list, int n) {
        Hologram hologram = HologramsAPI.createHologram((Plugin)ArenaAPI.PLUGIN, (Location)location);
        IHologramWrapper<Hologram> iHologramWrapper = new IHologramWrapper<Hologram>((IHologramHandler<Hologram>)this, hologram, n);
        this.setText(iHologramWrapper, list);
        return iHologramWrapper;
    }

    @Override
    public void setText(@NotNull IHologramWrapper<Hologram> iHologramWrapper, @NotNull List<String> list) {
        Hologram hologram = iHologramWrapper.hologram();
        hologram.clearLines();
        list.forEach(string -> {
            if (string.toLowerCase().startsWith("icon:")) {
                Material material = Material.getMaterial((String)string.substring("icon:".length()).trim().toUpperCase());
                if (material == null) {
                    return;
                }
                hologram.appendItemLine(new ItemStack(material));
            } else {
                hologram.appendTextLine(string);
            }
        });
    }

    @Override
    public void setClick(@NotNull IHologramWrapper<Hologram> iHologramWrapper, @NotNull IHologramClick iHologramClick) {
        Hologram hologram = iHologramWrapper.hologram();
        try {
            HologramLine hologramLine;
            int n = 0;
            while ((hologramLine = hologram.getLine(n++)) != null) {
                if (!(hologramLine instanceof TouchableLine)) continue;
                TouchableLine touchableLine = (TouchableLine)hologramLine;
                touchableLine.setTouchHandler(iHologramClick::onClick);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void delete(@NotNull IHologramWrapper<Hologram> iHologramWrapper) {
        iHologramWrapper.hologram().delete();
    }
}

