/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.hook.external;

import io.lumine.mythic.api.exceptions.InvalidMobTypeException;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythicMobsHook {
    private static final MythicBukkit MYTHIC_MOBS = MythicBukkit.inst();

    public static boolean isMythicMob(@NotNull Entity entity) {
        return MYTHIC_MOBS.getAPIHelper().isMythicMob(entity);
    }

    @Nullable
    public static ActiveMob getMobInstance(@NotNull Entity entity) {
        return MYTHIC_MOBS.getAPIHelper().getMythicMobInstance(entity);
    }

    @Nullable
    public static MythicMob getMobConfig(@NotNull Entity entity) {
        ActiveMob activeMob = MythicMobsHook.getMobInstance(entity);
        return activeMob != null ? activeMob.getType() : null;
    }

    @Nullable
    public static MythicMob getMobConfig(@NotNull String string) {
        return MYTHIC_MOBS.getAPIHelper().getMythicMob(string);
    }

    @NotNull
    public static String getMobInternalName(@NotNull Entity entity) {
        MythicMob mythicMob = MythicMobsHook.getMobConfig(entity);
        return mythicMob != null ? mythicMob.getInternalName() : "null";
    }

    @NotNull
    public static String getMobDisplayName(@NotNull String string) {
        MythicMob mythicMob = MythicMobsHook.getMobConfig(string);
        PlaceholderString placeholderString = mythicMob != null ? mythicMob.getDisplayName() : null;
        return placeholderString != null ? placeholderString.get() : string;
    }

    public static double getMobLevel(@NotNull Entity entity) {
        ActiveMob activeMob = MythicMobsHook.getMobInstance(entity);
        return activeMob != null ? activeMob.getLevel() : 0.0;
    }

    @NotNull
    public static List<String> getMobConfigIds() {
        return new ArrayList<String>(MYTHIC_MOBS.getMobManager().getMobNames());
    }

    public static void killMob(@NotNull Entity entity) {
        ActiveMob activeMob = MythicMobsHook.getMobInstance(entity);
        if (activeMob == null || activeMob.isDead()) {
            return;
        }
        activeMob.setDead();
        activeMob.remove();
        entity.remove();
    }

    public static boolean isValid(@NotNull String string) {
        return MythicMobsHook.getMobConfig(string) != null;
    }

    @Nullable
    public static Entity spawnMythicMob(@NotNull String string, @NotNull Location location, int n) {
        return MythicMobsHook.spawnMob(string, location, n);
    }

    @Nullable
    public static Entity spawnMob(@NotNull String string, @NotNull Location location, int n) {
        try {
            MythicMob mythicMob = MythicMobsHook.getMobConfig(string);
            return MYTHIC_MOBS.getAPIHelper().spawnMythicMob(mythicMob, location, n);
        }
        catch (InvalidMobTypeException invalidMobTypeException) {
            invalidMobTypeException.printStackTrace();
            return null;
        }
    }
}

