/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.hook.level;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.hook.level.PlayerLevelProvider;

public class PluginLevelProvider {
    private static final Map<String, PlayerLevelProvider> PROVIDERS = new HashMap<String, PlayerLevelProvider>();

    public static void registerProvider(@NotNull PlayerLevelProvider playerLevelProvider) {
        PROVIDERS.put(playerLevelProvider.getName().toLowerCase(), playerLevelProvider);
        ArenaAPI.PLUGIN.info("Registered level provider: " + playerLevelProvider.getName());
    }

    @Nullable
    public static PlayerLevelProvider getProvider(@NotNull String string) {
        return PROVIDERS.get(string.toLowerCase());
    }

    @NotNull
    public static Map<String, PlayerLevelProvider> getProvidersMap() {
        return PROVIDERS;
    }

    @NotNull
    public static Collection<PlayerLevelProvider> getProviders() {
        return PluginLevelProvider.getProvidersMap().values();
    }
}

