/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.kit.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.kit.KitManager;

public class KitsListEditor
extends EditorMenu<AMA, KitManager>
implements AutoPaged<Kit> {
    public KitsListEditor(@NotNull KitManager kitManager) {
        super((NexPlugin)((AMA)kitManager.plugin()), (Object)kitManager, "Arena Kit Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.KIT_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_KIT_ENTER_ID, inputWrapper -> {
            String string = StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw());
            if (!kitManager.createKit(string)) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.Editor_Kit_Error_Exist).getLocalized());
                return false;
            }
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((KitsListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<Kit> getObjects(@NotNull Player player) {
        return new ArrayList<Kit>(((KitManager)((Object)this.object)).getKits());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull Kit kit) {
        ItemStack itemStack = new ItemStack(kit.getIcon());
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.KIT_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.KIT_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)kit.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull Kit kit) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                if (!kit.getFile().delete()) {
                    return;
                }
                kit.clear();
                ((KitManager)((Object)((Object)this.object))).getKitsMap().remove(kit.getId());
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            kit.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

