/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.kill;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.config.JYML;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.arena.impl.ArenaPlayer;

public class MobKillReward {
    private final String mobId;
    private final Map<Currency, Double> payment;
    private final int score;

    public MobKillReward(@NotNull String string, @NotNull Map<Currency, Double> map, int n) {
        this.mobId = string.toLowerCase();
        this.payment = map;
        this.score = n;
    }

    @NotNull
    public static MobKillReward read(@NotNull JYML jYML, @NotNull String string, @NotNull String string2) {
        HashMap<Currency, Double> hashMap = new HashMap<Currency, Double>();
        for (String string3 : jYML.getSection(string + ".Currency")) {
            Currency currency = ArenaAPI.getCurrencyManager().getCurrency(string3);
            if (currency == null) continue;
            double d = jYML.getDouble(string + ".Currency." + string3);
            hashMap.put(currency, d);
        }
        int n = jYML.getInt(string + ".Score");
        return new MobKillReward(string2, hashMap, n);
    }

    public void write(@NotNull JYML jYML, @NotNull String string) {
        this.getPayment().forEach((currency, d) -> jYML.set(string + ".Currency." + currency.getId(), d));
        jYML.set(string + ".Score", (Object)this.getScore());
    }

    @NotNull
    public String getMobId() {
        return this.mobId;
    }

    public int getScore() {
        return this.score;
    }

    @NotNull
    public Map<Currency, Double> getPayment() {
        return this.payment;
    }

    public void reward(@NotNull ArenaPlayer arenaPlayer) {
        Player player = arenaPlayer.getPlayer();
        this.getPayment().forEach((currency, d) -> currency.getHandler().give(player, (double)d));
        arenaPlayer.addScore(this.getScore());
    }
}

