/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.kill;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.lang.LangMessage;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.PlayerUtil;
import su.nightexpress.ama.api.ArenaAPI;

public class MobKillStreak {
    private final int amount;
    private final LangMessage message;
    private final List<String> commands;

    public MobKillStreak(int n, @NotNull LangMessage langMessage, @NotNull List<String> list) {
        this.amount = n;
        this.message = langMessage.replace("%amount%", (Object)NumberUtil.format((double)this.getAmount()));
        this.commands = list;
    }

    @NotNull
    public static MobKillStreak read(@NotNull JYML jYML, @NotNull String string, int n) {
        LangMessage langMessage = new LangMessage((NexPlugin)ArenaAPI.PLUGIN, jYML.getString(string + ".Message", ""));
        List list = jYML.getStringList(string + ".Commands");
        return new MobKillStreak(n, langMessage, list);
    }

    public void write(@NotNull JYML jYML, @NotNull String string) {
        jYML.set(string + ".Message", (Object)this.getMessage().getRaw());
        jYML.set(string + ".Commands", this.getCommands());
    }

    public int getAmount() {
        return this.amount;
    }

    @NotNull
    public LangMessage getMessage() {
        return this.message;
    }

    @NotNull
    public List<String> getCommands() {
        return this.commands;
    }

    public void executeCommands(@NotNull Player player) {
        this.getCommands().forEach(string -> PlayerUtil.dispatchCommand((Player)player, (String)string));
    }

    public void execute(@NotNull Player player) {
        this.getMessage().send((CommandSender)player);
        this.executeCommands(player);
    }
}

