/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.style;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.utils.StringUtil;

public interface MobStyleWriter<E, T> {
    @Nullable
    public T parse(@NotNull String var1);

    @NotNull
    public T[] values();

    public void apply(@NotNull E var1, @NotNull T var2);

    public boolean alreadyHas(@NotNull E var1, @NotNull T var2);

    public static interface WriterEnum<E, T extends Enum<T>>
    extends MobStyleWriter<E, T> {
        @NotNull
        public Class<T> getEnumClass();

        @Override
        @Nullable
        default public T parse(@NotNull String value) {
            return (T)((Enum)StringUtil.getEnum((String)value, this.getEnumClass()).orElse(null));
        }

        @Override
        @NotNull
        default public T[] values() {
            return (Enum[])this.getEnumClass().getEnumConstants();
        }
    }

    public static interface WriterBoolean<E>
    extends MobStyleWriter<E, Boolean> {
        @Override
        @Nullable
        default public Boolean parse(@NotNull String value) {
            return Boolean.parseBoolean(value);
        }

        @NotNull
        default public Boolean[] values() {
            return new Boolean[]{true, false};
        }
    }
}

