/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.nms.v1_20_R1.brain.behavior.impl;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.PrepareRamNearestTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import su.nightexpress.ama.nms.v1_20_R1.brain.MobAI;
import su.nightexpress.ama.nms.v1_20_R1.mob.GoatMob;

public class PrepareRamTarget<E extends EntityCreature>
extends Behavior<E> {
    public static final int TIME_OUT_DURATION = 160;
    private final int minRamDistance;
    private final int maxRamDistance;
    private final float walkSpeed;
    private final int ramPrepareTime;
    private final Function<E, SoundEffect> getPrepareRamSound;
    private Optional<Long> reachedRamPositionTimestamp = Optional.empty();
    private Optional<PrepareRamNearestTarget.a> ramCandidate = Optional.empty();

    public PrepareRamTarget(int n, int n2, float f, int n3, Function<E, SoundEffect> function) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.n, (Object)MemoryStatus.c, (Object)MemoryModuleType.U, (Object)MemoryStatus.b, (Object)MemoryModuleType.o, (Object)MemoryStatus.a, (Object)MemoryModuleType.V, (Object)MemoryStatus.b), 160);
        this.minRamDistance = n;
        this.maxRamDistance = n2;
        this.walkSpeed = f;
        this.ramPrepareTime = n3;
        this.getPrepareRamSound = function;
    }

    protected void start(WorldServer worldServer, EntityCreature entityCreature, long l) {
        MobAI.getAngerTarget((EntityInsentient)entityCreature).ifPresent(entityLiving -> {
            EntityTargetLivingEntityEvent entityTargetLivingEntityEvent = CraftEventFactory.callEntityTargetLivingEvent((Entity)entityCreature, (EntityLiving)entityLiving, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET);
            if (!entityTargetLivingEntityEvent.isCancelled() && entityTargetLivingEntityEvent.getTarget() != null) {
                entityLiving = ((CraftLivingEntity)entityTargetLivingEntityEvent.getTarget()).getHandle();
                this.chooseRamPosition(entityCreature, (EntityLiving)entityLiving);
            }
        });
    }

    protected void stop(WorldServer worldServer, E e, long l) {
        BehaviorController behaviorController = e.dK();
        if (!behaviorController.a(MemoryModuleType.V)) {
            worldServer.a(e, (byte)59);
            behaviorController.a(MemoryModuleType.U, (Object)GoatMob.TIME_BETWEEN_RAMS.a());
        }
    }

    protected boolean canStillUse(WorldServer worldServer, EntityCreature entityCreature, long l) {
        return this.ramCandidate.isPresent() && this.ramCandidate.get().c().bs();
    }

    protected void tick(WorldServer worldServer, E e, long l) {
        if (this.ramCandidate.isPresent()) {
            e.dK().a(MemoryModuleType.m, (Object)new MemoryTarget(this.ramCandidate.get().a(), this.walkSpeed, 0));
            e.dK().a(MemoryModuleType.n, (Object)new BehaviorPositionEntity((Entity)this.ramCandidate.get().c(), true));
            BlockPosition blockPosition = e.di();
            if (blockPosition.equals((Object)this.ramCandidate.get().a())) {
                worldServer.a(e, (byte)58);
                if (this.reachedRamPositionTimestamp.isEmpty()) {
                    this.reachedRamPositionTimestamp = Optional.of(l);
                }
                if (l - this.reachedRamPositionTimestamp.get() >= (long)this.ramPrepareTime) {
                    e.dK().a(MemoryModuleType.V, (Object)this.getEdgeOfBlock(blockPosition, this.ramCandidate.get().c().di()));
                    worldServer.a(null, e, this.getPrepareRamSound.apply(e), SoundCategory.g, 1.0f, e.eS());
                    this.ramCandidate = Optional.empty();
                }
            }
        }
    }

    private Vec3D getEdgeOfBlock(BlockPosition blockPosition, BlockPosition blockPosition2) {
        double d = 0.5;
        double d2 = 0.5 * (double)MathHelper.j((double)(blockPosition2.u() - blockPosition.u()));
        double d3 = 0.5 * (double)MathHelper.j((double)(blockPosition2.w() - blockPosition.w()));
        return Vec3D.c((BaseBlockPosition)blockPosition2).b(d2, 0.0, d3);
    }

    private Optional<BlockPosition> calculateRammingStartPosition(EntityCreature entityCreature, EntityLiving entityLiving) {
        EnumDirection enumDirection2;
        BlockPosition blockPosition = entityLiving.di();
        if (!this.isWalkableBlock(entityCreature, blockPosition)) {
            return Optional.empty();
        }
        ArrayList<BlockPosition> arrayList = new ArrayList<BlockPosition>();
        BlockPosition.MutableBlockPosition mutableBlockPosition = blockPosition.j();
        for (EnumDirection enumDirection2 : EnumDirection.EnumDirectionLimit.a) {
            mutableBlockPosition.g((BaseBlockPosition)blockPosition);
            for (int i = 0; i < this.maxRamDistance; ++i) {
                if (this.isWalkableBlock(entityCreature, (BlockPosition)mutableBlockPosition.c(enumDirection2))) continue;
                mutableBlockPosition.c(enumDirection2.g());
                break;
            }
            if (mutableBlockPosition.k((BaseBlockPosition)blockPosition) < this.minRamDistance) continue;
            arrayList.add(mutableBlockPosition.i());
        }
        Iterator iterator = entityCreature.J();
        enumDirection2 = entityCreature.di();
        return arrayList.stream().sorted(Comparator.comparingDouble(arg_0 -> ((BlockPosition)enumDirection2).j(arg_0))).filter(arg_0 -> PrepareRamTarget.lambda$calculateRammingStartPosition$1((NavigationAbstract)iterator, arg_0)).findFirst();
    }

    private boolean isWalkableBlock(EntityCreature entityCreature, BlockPosition blockPosition) {
        return entityCreature.J().a(blockPosition) && entityCreature.a(PathfinderNormal.a((IBlockAccess)entityCreature.dI(), (BlockPosition.MutableBlockPosition)blockPosition.j())) == 0.0f;
    }

    private void chooseRamPosition(EntityCreature entityCreature, EntityLiving entityLiving) {
        this.reachedRamPositionTimestamp = Optional.empty();
        this.ramCandidate = this.calculateRammingStartPosition(entityCreature, entityLiving).map(blockPosition -> new PrepareRamNearestTarget.a(blockPosition, entityLiving.di(), entityLiving));
    }

    private static /* synthetic */ boolean lambda$calculateRammingStartPosition$1(NavigationAbstract navigationAbstract, BlockPosition blockPosition) {
        PathEntity pathEntity = navigationAbstract.a(blockPosition, 0);
        return pathEntity != null && pathEntity.j();
    }
}

