/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.pets.impl.utils;

import net.advancedplugins.pets.impl.utils.ASManager;
import net.advancedplugins.pets.impl.utils.hooks.HookPlugin;
import net.advancedplugins.pets.impl.utils.hooks.HooksHandler;
import net.advancedplugins.pets.impl.utils.hooks.plugins.ItemsAdderHook;
import net.advancedplugins.pets.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ItemDurability {
    @Nullable
    private LivingEntity itemHolder;
    private ItemStack item;
    private int dealtDamage = 0;
    private final boolean itemsAdder;
    private static final String a = ItemDurability.a(40, ItemDurability.a("$`(}C"));

    public ItemDurability(ItemStack itemStack) {
        this(null, itemStack);
    }

    public ItemDurability(@Nullable LivingEntity livingEntity, ItemStack itemStack) {
        this.itemHolder = livingEntity;
        this.item = itemStack == null ? new ItemStack(Material.AIR) : itemStack;
        this.itemsAdder = HooksHandler.isEnabled(HookPlugin.ITEMSADDER) && ((ItemsAdderHook)HooksHandler.getHook(HookPlugin.ITEMSADDER)).isCustomItem(this.item);
    }

    public ItemStack getItemStack() {
        if (this.item.getAmount() == 0) {
            this.item.setAmount(1);
        }
        if (this.item.getType().getMaxDurability() == 0) {
            return this.item;
        }
        if (this.isBroken() && !ASManager.isUnbreakable(this.item)) {
            return new ItemStack(Material.AIR);
        }
        return this.item;
    }

    public int getUnbreakingLevel() {
        return this.item.getEnchantmentLevel(Enchantment.DURABILITY);
    }

    /*
     * Loose catch block
     */
    public ItemDurability damageItem(short s) {
        try {
            block9: {
                block8: {
                    block7: {
                        if (!ASManager.isDamageable(this.item.getType())) break block7;
                        try {
                            block10: {
                                if (this.item.getType().name().contains(a)) break block7;
                                break block10;
                                catch (Exception exception) {
                                    throw ItemDurability.b(exception);
                                }
                            }
                            if (!ASManager.isUnbreakable(this.item)) break block8;
                        }
                        catch (Exception exception) {
                            throw ItemDurability.b(exception);
                        }
                    }
                    return this;
                }
                if (s >= 0) break block9;
                this.healItem(s);
                return this;
            }
            int n = this.getMaxDurability();
            if (this.getDurability() + s > n) {
                this.setDurability(n);
                return this;
            }
            this.setDurability(this.getDurability() + s);
            this.dealtDamage += s;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public boolean isBroken() {
        return this.getDurability() >= this.getMaxDurability();
    }

    public ItemDurability healItem(short s) {
        s = (short)Math.abs(s);
        if (!ASManager.isDamageable(this.item.getType())) {
            return this;
        }
        if (this.item.getType().name().contains(a)) {
            return this;
        }
        if (this.getDurability() - s < 0) {
            this.repairItem();
            return this;
        }
        this.setDurability(this.getDurability() - s);
        return this;
    }

    public ItemDurability handleDurabilityChange(int n) {
        if (n < 0) {
            return this.damageItem((short)(-n));
        }
        return this.healItem((short)n);
    }

    public int getMaxDurability() {
        if (this.itemsAdder) {
            return ((ItemsAdderHook)HooksHandler.getHook(HookPlugin.ITEMSADDER)).getCustomItemMaxDurability(this.item);
        }
        return this.item.getType().getMaxDurability();
    }

    public int getDurability() {
        if (this.itemsAdder) {
            return this.getMaxDurability() - ((ItemsAdderHook)HooksHandler.getHook(HookPlugin.ITEMSADDER)).getCustomItemDurability(this.item);
        }
        return this.item.getDurability();
    }

    public ItemDurability setDurability(int n) {
        if (this.itemsAdder) {
            this.item = ((ItemsAdderHook)HooksHandler.getHook(HookPlugin.ITEMSADDER)).setCustomItemDurability(this.item, n < this.getMaxDurability() ? this.getMaxDurability() - n : -1);
            return this;
        }
        if (n >= this.getMaxDurability() && this.itemHolder != null && this.itemHolder instanceof Player && this.item.getItemMeta() instanceof Damageable) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerItemBreakEvent((Player)this.itemHolder, this.item));
        }
        this.setDurabilityVersionSave(n);
        return this;
    }

    private int getDurabilityVersionSafe() {
        if (MinecraftVersion.getVersionNumber() >= 1130) {
            ItemMeta itemMeta = this.item.getItemMeta();
            if (itemMeta instanceof Damageable) {
                Damageable damageable = (Damageable)itemMeta;
                return damageable.getDamage();
            }
            return -1;
        }
        return this.item.getDurability();
    }

    private void setDurabilityVersionSave(int n) {
        block5: {
            block4: {
                int[] nArray = ASManager.b();
                if (MinecraftVersion.getVersionNumber() < 1130) break block4;
                ItemMeta itemMeta = this.item.getItemMeta();
                if (itemMeta instanceof Damageable) {
                    Damageable damageable = (Damageable)itemMeta;
                    damageable.setDamage(n);
                    this.item.setItemMeta(itemMeta);
                }
                if (nArray != null) break block5;
            }
            this.item.setDurability((short)n);
        }
    }

    public ItemDurability repairItem() {
        this.setDurability(0);
        return this;
    }

    public int getDealtDamage() {
        return this.dealtDamage;
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x64);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 95;
                        break;
                    }
                    case 1: {
                        n5 = 3;
                        break;
                    }
                    case 2: {
                        n5 = 85;
                        break;
                    }
                    case 3: {
                        n5 = 25;
                        break;
                    }
                    case 4: {
                        n5 = 39;
                        break;
                    }
                    case 5: {
                        n5 = 58;
                        break;
                    }
                    default: {
                        n5 = 100;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

