/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.pets.libs.apache.commons.math3.distribution;

import net.advancedplugins.pets.impl.commons.effects.effects.AdvancedEffect;
import net.advancedplugins.pets.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.pets.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.pets.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.pets.libs.apache.commons.math3.special.Beta;
import net.advancedplugins.pets.libs.apache.commons.math3.util.FastMath;

public class FDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -8516354193418641566L;
    private final double numeratorDegreesOfFreedom;
    private final double denominatorDegreesOfFreedom;
    private final double solverAbsoluteAccuracy;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated = false;

    public FDistribution(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public FDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public FDistribution(RandomGenerator randomGenerator, double d, double d2) {
        this(randomGenerator, d, d2, 1.0E-9);
    }

    public FDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DEGREES_OF_FREEDOM, d);
        }
        try {
            if (d2 <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DEGREES_OF_FREEDOM, d2);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw FDistribution.b(notStrictlyPositiveException);
        }
        this.numeratorDegreesOfFreedom = d;
        this.denominatorDegreesOfFreedom = d2;
        this.solverAbsoluteAccuracy = d3;
    }

    public double density(double d) {
        return FastMath.exp(this.logDensity(d));
    }

    public double logDensity(double d) {
        double d2;
        double d3 = this.numeratorDegreesOfFreedom / 2.0;
        double d4 = this.denominatorDegreesOfFreedom / 2.0;
        double d5 = FastMath.log(d);
        String[] stringArray = AbstractRealDistribution.b();
        double d6 = FastMath.log(this.numeratorDegreesOfFreedom);
        double d7 = FastMath.log(this.denominatorDegreesOfFreedom);
        double d8 = FastMath.log(this.numeratorDegreesOfFreedom * d + this.denominatorDegreesOfFreedom);
        try {
            d2 = d3 * d6 + d3 * d5 - d5 + d4 * d7 - d3 * d8 - d4 * d8 - Beta.logBeta(d3, d4);
            if (AdvancedEffect.b() != null) {
                AbstractRealDistribution.b(new String[3]);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw FDistribution.b(notStrictlyPositiveException);
        }
        return d2;
    }

    public double cumulativeProbability(double d) {
        double d2;
        block3: {
            block2: {
                String[] stringArray = AbstractRealDistribution.b();
                if (!(d <= 0.0)) break block2;
                d2 = 0.0;
                if (stringArray != null) break block3;
            }
            double d3 = this.numeratorDegreesOfFreedom;
            double d4 = this.denominatorDegreesOfFreedom;
            d2 = Beta.regularizedBeta(d3 * d / (d4 + d3 * d), 0.5 * d3, 0.5 * d4);
        }
        return d2;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        double d = this.getDenominatorDegreesOfFreedom();
        try {
            if (d > 2.0) {
                return d / (d - 2.0);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw FDistribution.b(notStrictlyPositiveException);
        }
        return Double.NaN;
    }

    public double getNumericalVariance() {
        try {
            if (!this.numericalVarianceIsCalculated) {
                this.numericalVariance = this.calculateNumericalVariance();
                this.numericalVarianceIsCalculated = true;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw FDistribution.b(notStrictlyPositiveException);
        }
        return this.numericalVariance;
    }

    protected double calculateNumericalVariance() {
        double d = this.getDenominatorDegreesOfFreedom();
        if (d > 4.0) {
            double d2 = this.getNumeratorDegreesOfFreedom();
            double d3 = d - 2.0;
            return 2.0 * (d * d) * (d2 + d - 2.0) / (d2 * (d3 * d3) * (d - 4.0));
        }
        return Double.NaN;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }
}

