/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.armorutils;

import java.util.Arrays;
import java.util.List;
import net.advancedplugins.as.impl.effects.armorutils.ArmorEquipEvent;
import net.advancedplugins.as.impl.effects.armorutils.ArmorType;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.SchedulerUtils;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ArmorListener
implements Listener {
    private final List<String> blockedMaterials = Arrays.asList("DISPENSER", "DROPPER", "DOOR", "TRAP_DOOR", "GATE", "WALL_SIGN", "SIGN_POST", "CHEST", "ENDER_CHEST", "BEACON", "DOUBLE_CHEST", "TRAPPED_CHEST", "ANVIL", "LEVER", "CAULDRON", "FENCE", "CRAFTING_TABLE", "WORKBENCH", "SHULKER", "CAKE");

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        boolean bl = false;
        boolean bl2 = false;
        if (inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT || inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT) {
            bl = true;
        }
        if (inventoryClickEvent.getClick() == ClickType.NUMBER_KEY) {
            bl2 = true;
        }
        if (inventoryClickEvent.getSlotType() != InventoryType.SlotType.ARMOR && inventoryClickEvent.getSlotType() != InventoryType.SlotType.QUICKBAR && inventoryClickEvent.getSlotType() != InventoryType.SlotType.CONTAINER) {
            return;
        }
        if (inventoryClickEvent.getClickedInventory() != null && inventoryClickEvent.getClickedInventory().getType() != InventoryType.PLAYER) {
            return;
        }
        if (inventoryClickEvent.getInventory().getType() != InventoryType.CRAFTING && inventoryClickEvent.getInventory().getType() != InventoryType.PLAYER) {
            return;
        }
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        ArmorType armorType = ArmorType.matchType(bl ? inventoryClickEvent.getCurrentItem() : inventoryClickEvent.getCursor());
        if (inventoryClickEvent.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD && armorType == null) {
            armorType = ArmorType.matchType(inventoryClickEvent.getCurrentItem());
        }
        if (inventoryClickEvent.getAction() == InventoryAction.SWAP_WITH_CURSOR) {
            armorType = ArmorType.matchType(inventoryClickEvent.getCursor());
        }
        if (!bl && armorType != null && inventoryClickEvent.getRawSlot() != armorType.getSlot()) {
            return;
        }
        if (bl) {
            armorType = ArmorType.matchType(inventoryClickEvent.getCurrentItem());
            if (armorType != null) {
                boolean bl3 = true;
                if (inventoryClickEvent.getRawSlot() == armorType.getSlot()) {
                    if (inventoryClickEvent.getWhoClicked().getInventory().firstEmpty() == -1) {
                        inventoryClickEvent.setCancelled(true);
                        return;
                    }
                    bl3 = false;
                }
                if (armorType == ArmorType.HELMET && bl3 == ASManager.isAir(inventoryClickEvent.getWhoClicked().getInventory().getHelmet()) || armorType == ArmorType.CHESTPLATE && bl3 == ASManager.isAir(inventoryClickEvent.getWhoClicked().getInventory().getChestplate()) || armorType == ArmorType.LEGGINGS && bl3 == ASManager.isAir(inventoryClickEvent.getWhoClicked().getInventory().getLeggings()) || armorType == ArmorType.BOOTS && bl3 == ASManager.isAir(inventoryClickEvent.getWhoClicked().getInventory().getBoots())) {
                    if (bl3) {
                        ArmorType armorType2 = armorType;
                        ItemStack itemStack = inventoryClickEvent.getCurrentItem().clone();
                        SchedulerUtils.runTaskLater(() -> {
                            ItemStack itemStack2 = inventoryClickEvent.getWhoClicked().getInventory().getItem(armorType2.getEquipmentSlot());
                            if (itemStack.isSimilar(itemStack2)) {
                                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)inventoryClickEvent.getWhoClicked(), ArmorEquipEvent.EquipMethod.SHIFT_CLICK, armorType2, null, itemStack);
                                Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
                            }
                        });
                    } else {
                        ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)inventoryClickEvent.getWhoClicked(), ArmorEquipEvent.EquipMethod.SHIFT_CLICK, armorType, inventoryClickEvent.getCurrentItem(), null);
                        Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
                        if (armorEquipEvent.isCancelled()) {
                            inventoryClickEvent.setCancelled(true);
                        }
                    }
                }
            }
        } else {
            Object object;
            if (MinecraftVersion.getVersionNumber() >= 1160 && inventoryClickEvent.getAction() == InventoryAction.HOTBAR_SWAP && inventoryClickEvent.getClick() == ClickType.SWAP_OFFHAND) {
                EntityEquipment entityEquipment = inventoryClickEvent.getWhoClicked().getEquipment();
                if (entityEquipment == null) {
                    return;
                }
                ItemStack itemStack = null;
                ItemStack itemStack2 = entityEquipment.getItemInOffHand();
                switch (inventoryClickEvent.getRawSlot()) {
                    case 5: {
                        itemStack = entityEquipment.getHelmet();
                        armorType = ArmorType.HELMET;
                        break;
                    }
                    case 6: {
                        itemStack = entityEquipment.getChestplate();
                        armorType = ArmorType.CHESTPLATE;
                        break;
                    }
                    case 7: {
                        itemStack = entityEquipment.getLeggings();
                        armorType = ArmorType.LEGGINGS;
                        break;
                    }
                    case 8: {
                        itemStack = entityEquipment.getBoots();
                        armorType = ArmorType.BOOTS;
                        break;
                    }
                    case 45: {
                        return;
                    }
                }
                if (itemStack == null) {
                    itemStack = new ItemStack(Material.AIR);
                }
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)inventoryClickEvent.getWhoClicked(), ArmorEquipEvent.EquipMethod.OFFHAND_SWAP, armorType, itemStack, itemStack2);
                Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    inventoryClickEvent.setCancelled(true);
                }
                return;
            }
            if (inventoryClickEvent.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) {
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)inventoryClickEvent.getWhoClicked(), ArmorEquipEvent.EquipMethod.HOTBAR_SWAP, armorType, inventoryClickEvent.getCurrentItem(), null);
                Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    inventoryClickEvent.setCancelled(true);
                }
                return;
            }
            ItemStack itemStack = inventoryClickEvent.getCursor();
            ItemStack itemStack3 = inventoryClickEvent.getCurrentItem();
            if (bl2) {
                if (inventoryClickEvent.getClickedInventory().getType() == InventoryType.PLAYER) {
                    object = inventoryClickEvent.getClickedInventory().getItem(inventoryClickEvent.getHotbarButton());
                    if (!ASManager.isAir(object)) {
                        armorType = ArmorType.matchType(object);
                        itemStack = object;
                        itemStack3 = inventoryClickEvent.getClickedInventory().getItem(inventoryClickEvent.getSlot());
                    } else {
                        armorType = ArmorType.matchType(!ASManager.isAir(inventoryClickEvent.getCurrentItem()) ? inventoryClickEvent.getCurrentItem() : inventoryClickEvent.getCursor());
                    }
                }
            } else if (ASManager.isAir(inventoryClickEvent.getCursor()) && !ASManager.isAir(inventoryClickEvent.getCurrentItem())) {
                armorType = ArmorType.matchType(inventoryClickEvent.getCurrentItem());
            }
            if (armorType != null && inventoryClickEvent.getRawSlot() == armorType.getSlot()) {
                object = ArmorEquipEvent.EquipMethod.PICK_DROP;
                if (inventoryClickEvent.getAction() == InventoryAction.HOTBAR_SWAP || bl2) {
                    object = ArmorEquipEvent.EquipMethod.HOTBAR_SWAP;
                }
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)inventoryClickEvent.getWhoClicked(), (ArmorEquipEvent.EquipMethod)((Object)object), armorType, itemStack3, itemStack);
                Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    inventoryClickEvent.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerInteractEvent(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled() && playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (playerInteractEvent.getAction() == Action.PHYSICAL) {
            return;
        }
        if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR || playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK && playerInteractEvent.getClickedBlock().getState() instanceof InventoryHolder) {
                return;
            }
            if (playerInteractEvent.getClickedBlock() != null && playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (MinecraftVersion.isNew() && playerInteractEvent.getClickedBlock().getType().isInteractable()) {
                    return;
                }
                Material material = playerInteractEvent.getClickedBlock().getType();
                for (String object2 : this.blockedMaterials) {
                    if (!material.name().contains(object2)) continue;
                    return;
                }
            }
            if (playerInteractEvent.getItem() != null) {
                boolean bl = playerInteractEvent.getItem().getType().name().endsWith("HEAD") || playerInteractEvent.getItem().getType().name().endsWith("SKULL") && playerInteractEvent.getItem().hasItemMeta();
            } else {
                boolean bl = false;
            }
            if (playerInteractEvent.getItem() != null && playerInteractEvent.getItem().getType().isBlock() && playerInteractEvent.getPlayer().getTargetBlock(null, 5).getType().isSolid()) {
                return;
            }
            Player player = playerInteractEvent.getPlayer();
            ArmorType armorType = ArmorType.matchType(playerInteractEvent.getItem());
            if (armorType != null) {
                String string = playerInteractEvent.getItem().getType().name();
                if (string.contains("HEAD") || string.contains("SKULL")) {
                    return;
                }
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.HOTBAR, armorType, player.getInventory().getItem(armorType.getEquipmentSlot()), playerInteractEvent.getItem());
                Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    playerInteractEvent.setCancelled(true);
                    player.updateInventory();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void inventoryDrag(InventoryDragEvent inventoryDragEvent) {
        ArmorType armorType = ArmorType.matchType(inventoryDragEvent.getOldCursor());
        if (inventoryDragEvent.getRawSlots().isEmpty()) {
            return;
        }
        if (!(inventoryDragEvent.getInventory() instanceof PlayerInventory)) {
            return;
        }
        if (armorType != null && armorType.getSlot() == inventoryDragEvent.getRawSlots().stream().findFirst().orElse(0).intValue()) {
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)inventoryDragEvent.getWhoClicked(), ArmorEquipEvent.EquipMethod.DRAG, armorType, null, inventoryDragEvent.getOldCursor());
            Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                inventoryDragEvent.setResult(Event.Result.DENY);
                inventoryDragEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void itemBreakEvent(PlayerItemBreakEvent playerItemBreakEvent) {
        ArmorType armorType = ArmorType.matchType(playerItemBreakEvent.getBrokenItem());
        if (armorType != null) {
            Player player = playerItemBreakEvent.getPlayer();
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.BROKE, armorType, playerItemBreakEvent.getBrokenItem(), null);
            Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                ItemStack itemStack = playerItemBreakEvent.getBrokenItem().clone();
                itemStack.setAmount(1);
                itemStack.setDurability((short)(itemStack.getDurability() - 1));
                switch (armorType) {
                    case HELMET: {
                        player.getInventory().setHelmet(itemStack);
                        break;
                    }
                    case CHESTPLATE: {
                        player.getInventory().setChestplate(itemStack);
                        break;
                    }
                    case LEGGINGS: {
                        player.getInventory().setLeggings(itemStack);
                        break;
                    }
                    case BOOTS: {
                        player.getInventory().setBoots(itemStack);
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerDeathEvent(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        ArmorType.getArmorContents((LivingEntity)player).forEach((armorType, itemStack) -> {
            if (!ASManager.isValid(itemStack)) {
                return;
            }
            Bukkit.getPluginManager().callEvent((Event)new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.DEATH, (ArmorType)((Object)armorType), (ItemStack)itemStack, null));
        });
    }
}

