/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.effects.internal;

import java.util.Iterator;
import net.advancedplugins.as.impl.effects.effects.actions.execution.ExecutionTask;
import net.advancedplugins.as.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.BreakWholeTree;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class BreakTreeEffect
extends AdvancedEffect {
    public BreakTreeEffect(JavaPlugin javaPlugin) {
        super(javaPlugin, "BREAK_TREE", "Break a whole tree at once", "%e");
        this.setBlockEffect(true);
    }

    @Override
    public boolean executeEffect(ExecutionTask executionTask, LivingEntity livingEntity, String[] stringArray) {
        return this.executeEffect(executionTask, executionTask.getBuilder().getBlock().getLocation(), stringArray);
    }

    @Override
    public boolean executeEffect(ExecutionTask executionTask, Location location, String[] stringArray) {
        Block block = location.getBlock();
        if (!ASManager.isLog(block.getType())) {
            return true;
        }
        Iterator<Block> iterator = new BreakWholeTree(block).get().iterator();
        while (iterator.hasNext()) {
            Block block2 = iterator.next();
            if (block2.equals(block)) continue;
            if (block2.hasMetadata("AE_Placed")) {
                iterator.remove();
                continue;
            }
            executionTask.getBuilder().getDrops().addDrops(block2, new ItemStack(block2.getType()));
        }
        executionTask.getBuilder().getDrops().getSettings().setBreakBlocks(true);
        return true;
    }
}

