/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.effects.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.effects.effects.actions.execution.ExecutionTask;
import net.advancedplugins.as.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.ColorUtils;
import net.advancedplugins.as.impl.utils.EntitySpawnUtils;
import net.advancedplugins.as.impl.utils.MathUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GuardEffect
extends AdvancedEffect {
    private final Map<UUID, UUID> guards = new HashMap<UUID, UUID>();
    private static GuardEffect guardEffect;

    public GuardEffect(JavaPlugin javaPlugin) {
        super(javaPlugin, "GUARD", "Spawn a mob guarding player", "%e:<ENTITY>:<AMOUNT:><NAME>");
        this.addArgument(0, EntityType.class);
        this.addArgument(1, String.class);
        guardEffect = this;
    }

    @Override
    public boolean executeEffect(ExecutionTask executionTask, LivingEntity livingEntity, String[] stringArray) {
        String string;
        String string2 = stringArray[0].toUpperCase(Locale.ROOT);
        boolean bl = string2.startsWith("BABY_");
        String string3 = string = bl ? string2.substring("BABY_".length()) : string2;
        if (!ASManager.isValidEnum(EntityType.class, string)) {
            EffectsHandler.getInstance().getLogger().warning("Tried to summon GUARD of invalid entity type: \"" + string + "\".");
            return false;
        }
        EntityType entityType = EntityType.valueOf((String)string);
        int n = 160;
        int n2 = 1;
        if (stringArray.length > 1 && MathUtils.isInteger(stringArray[1])) {
            n = ASManager.parseInt(stringArray[1]) * 20;
        }
        if (stringArray.length > 2 && MathUtils.isInteger(stringArray[2])) {
            n2 = ASManager.parseInt(stringArray[2]);
        }
        String string4 = "";
        if (stringArray.length > 3) {
            string4 = StringUtils.join((Object[])Arrays.copyOfRange(stringArray, stringArray.length > 3 ? 3 : 1, stringArray.length));
            string4 = ColorUtils.format(string4.replaceAll("%player name%", livingEntity.getName()));
        }
        this.summonGuard(entityType, bl, string4, n, n2, this.getOtherEntity(livingEntity, executionTask));
        return true;
    }

    public boolean isGuard(Entity entity) {
        return this.guards.containsKey(entity.getUniqueId());
    }

    public void steal(UUID uUID, UUID uUID2) {
        if (!this.guards.containsValue(uUID)) {
            return;
        }
        HashMap<UUID, UUID> hashMap = new HashMap<UUID, UUID>(this.guards);
        for (Map.Entry<UUID, UUID> entry : this.getGuards().entrySet()) {
            if (!Objects.equals(entry.getValue(), uUID)) continue;
            hashMap.remove(entry.getKey(), uUID);
            hashMap.put(entry.getKey(), uUID2);
            Entity entity = Bukkit.getEntity((UUID)entry.getKey());
            if (!(entity instanceof Creature)) continue;
            ((Creature)entity).setTarget((LivingEntity)Bukkit.getPlayer((UUID)uUID2));
        }
        this.guards.putAll(hashMap);
    }

    public void summonGuard(EntityType entityType, boolean bl, String string, int n, int n2, LivingEntity livingEntity) {
        for (int i = 0; i < n2; ++i) {
            this.summonGuard(entityType, bl, string, n, livingEntity);
        }
    }

    public void summonGuard(EntityType entityType, boolean bl, String string, int n, LivingEntity livingEntity) {
        Entity entity = EntitySpawnUtils.spawnEntity((Plugin)this.getPlugin(), livingEntity.getWorld(), livingEntity.getLocation(), entityType);
        if (string != null && !string.isEmpty()) {
            entity.setCustomName(string);
            entity.setCustomNameVisible(true);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            livingEntity2.setCanPickupItems(false);
            livingEntity2.setRemoveWhenFarAway(true);
            livingEntity2.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, n, 1, false, true));
        }
        this.guards.put(entity.getUniqueId(), livingEntity.getUniqueId());
        if (entity instanceof Creature) {
            ((Creature)entity).setTarget(livingEntity);
        }
        if (bl && entity instanceof Ageable) {
            ((Ageable)entity).setBaby();
        }
        Bukkit.getScheduler().runTaskLater((Plugin)EffectsHandler.getInstance(), () -> {
            entity.remove();
            if (!entity.isDead() && entity instanceof LivingEntity) {
                ((LivingEntity)entity).damage(2.147483647E9);
            }
        }, (long)n);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplode(ExplosionPrimeEvent explosionPrimeEvent) {
        if (!this.isGuard(explosionPrimeEvent.getEntity())) {
            return;
        }
        if (!(explosionPrimeEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)explosionPrimeEvent.getEntity();
        livingEntity.getActivePotionEffects().forEach(potionEffect -> livingEntity.removePotionEffect(potionEffect.getType()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGuardDeath(EntityDeathEvent entityDeathEvent) {
        if (!this.isGuard((Entity)entityDeathEvent.getEntity())) {
            return;
        }
        entityDeathEvent.setDroppedExp(0);
        entityDeathEvent.getDrops().clear();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void entityTargetEvent(EntityTargetEvent entityTargetEvent) {
        if (!this.isGuard(entityTargetEvent.getEntity())) {
            return;
        }
        if (!(entityTargetEvent.getTarget() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityTargetEvent.getTarget();
        if (livingEntity.getUniqueId().equals(this.guards.get(entityTargetEvent.getEntity().getUniqueId()))) {
            return;
        }
        entityTargetEvent.setCancelled(true);
        LivingEntity livingEntity2 = null;
        double d = 32.0;
        for (Entity entity : entityTargetEvent.getTarget().getNearbyEntities(d, d, d)) {
            double d2;
            if (!(entity instanceof LivingEntity) || entity.getUniqueId().equals(entity.getUniqueId()) || !((d2 = entity.getLocation().distance(livingEntity.getLocation())) < d)) continue;
            livingEntity2 = (LivingEntity)entity;
            d = d2;
        }
        if (livingEntity2 == null) {
            return;
        }
        entityTargetEvent.setTarget(livingEntity2);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (!this.isGuard((Entity)creatureSpawnEvent.getEntity())) {
            return;
        }
        creatureSpawnEvent.setCancelled(false);
    }

    public Map<UUID, UUID> getGuards() {
        return this.guards;
    }

    public static GuardEffect getGuardEffect() {
        return guardEffect;
    }
}

