/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.effects.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.effects.effects.actions.execution.ExecutionTask;
import net.advancedplugins.as.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.Pair;
import net.advancedplugins.as.impl.utils.ReallyFastBlockHandler;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.HooksHandler;
import net.advancedplugins.as.impl.utils.hooks.factions.FactionsPluginHook;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WaterWalkerEffect
extends AdvancedEffect {
    private final HashSet<UUID> activatedUsers = new HashSet();
    private static final Map<Integer, Pair<Block[], Material>> removalTasks = new HashMap<Integer, Pair<Block[], Material>>();

    public WaterWalkerEffect(JavaPlugin javaPlugin) {
        super(javaPlugin, "WATER_WALKER", "Walk on water", "%e");
    }

    @Override
    public boolean executeEffect(ExecutionTask executionTask, LivingEntity livingEntity, String[] stringArray) {
        if (!executionTask.getBuilder().isPermanent()) {
            this.warn(this.getName() + " can only be used as permanent effect.");
            return false;
        }
        if (executionTask.getBuilder().isRemoved()) {
            this.activatedUsers.remove(livingEntity.getUniqueId());
            return true;
        }
        this.activatedUsers.add(livingEntity.getUniqueId());
        return true;
    }

    @EventHandler
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        if (this.activatedUsers.isEmpty()) {
            return;
        }
        if (playerMoveEvent.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (playerMoveEvent.getPlayer().isFlying()) {
            return;
        }
        if (playerMoveEvent.getFrom().getBlock().equals(playerMoveEvent.getTo().getBlock())) {
            return;
        }
        if (ASManager.sameBlock(playerMoveEvent.getFrom(), playerMoveEvent.getTo())) {
            return;
        }
        if (!this.activatedUsers.contains(playerMoveEvent.getPlayer().getUniqueId())) {
            return;
        }
        this.scanBlocks(playerMoveEvent.getPlayer(), playerMoveEvent.getTo());
    }

    private void scanBlocks(Player player, Location location) {
        Location location2 = location.clone().subtract(0.0, 1.0, 0.0);
        Block block = location2.getBlock();
        int n = 2;
        ArrayList<Block> arrayList = new ArrayList<Block>();
        if (n <= 2) {
            arrayList.add(block);
            arrayList.add(block.getRelative(BlockFace.NORTH));
            arrayList.add(block.getRelative(BlockFace.EAST));
            arrayList.add(block.getRelative(BlockFace.SOUTH));
            arrayList.add(block.getRelative(BlockFace.WEST));
        } else {
            int n2 = location2.getBlockX();
            int n3 = location2.getBlockY();
            int n4 = location2.getBlockZ();
            World world = location2.getWorld();
            int n5 = n * n;
            for (int i = n2 - n; i <= n2 + n; ++i) {
                for (int j = n4 - n; j <= n4 + n; ++j) {
                    if ((n2 - i) * (n2 - i) + (n4 - j) * (n4 - j) > n5) continue;
                    arrayList.add(world.getBlockAt(i, n3, j));
                }
            }
        }
        this.checkAndSet(player, arrayList, "WATER");
    }

    private void checkAndSet(Player player, List<Block> list, String string) {
        Block[] blockArray;
        if (HooksHandler.isEnabled(HookPlugin.FACTIONS) && !(blockArray = ((FactionsPluginHook)HooksHandler.getHook(HookPlugin.FACTIONS)).getRelationOfLand(player)).equalsIgnoreCase("Wilderness") && !blockArray.equalsIgnoreCase("null") && !blockArray.equalsIgnoreCase("neutral")) {
            return;
        }
        list.removeIf(block -> !block.isLiquid() || !block.getType().name().endsWith(string) || block.getData() != 0 || !EffectsHandler.getProtection().canBreak(block.getLocation(), player) || block.getRelative(BlockFace.UP).getType().name().equals("LILY_PAD"));
        if (list.isEmpty()) {
            return;
        }
        for (Block block2 : list) {
            block2.setMetadata("cancelBreak", (MetadataValue)new FixedMetadataValue((Plugin)EffectsHandler.getInstance(), (Object)true));
        }
        blockArray = list.toArray(new Block[0]);
        this.removeBlockLater(blockArray, list.get(0).getType());
        ReallyFastBlockHandler.getForWorld(player.getWorld()).setType(Material.OBSIDIAN, blockArray);
    }

    private void removeBlockLater(Block[] blockArray, Material material) {
        int n = Bukkit.getScheduler().runTaskLater((Plugin)EffectsHandler.getInstance(), () -> {
            ReallyFastBlockHandler.getForWorld(blockArray[0].getWorld()).setType(material, blockArray);
            for (Block block : blockArray) {
                block.removeMetadata("cancelBreak", (Plugin)EffectsHandler.getInstance());
            }
        }, 100L).getTaskId();
        removalTasks.remove(n);
    }

    public static void clearQueue() {
        removalTasks.forEach((n, pair) -> {
            Bukkit.getScheduler().cancelTask(n.intValue());
            ReallyFastBlockHandler.getForWorld(((Block[])pair.getKey())[0].getWorld()).setType((Material)pair.getValue(), (Block[])pair.getKey());
        });
    }
}

