/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.mechanics.triggers.internal;

import net.advancedplugins.as.impl.effects.effects.actions.AdvancedTrigger;
import net.advancedplugins.as.impl.effects.effects.actions.utils.GetAllRollItems;
import net.advancedplugins.as.impl.effects.effects.actions.utils.RollItemType;
import net.advancedplugins.as.impl.effects.effects.actions.utils.StackItem;
import net.advancedplugins.as.impl.utils.ASManager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class DeathTrigger
extends AdvancedTrigger {
    public DeathTrigger() {
        super("DEATH");
        this.setComboEnabled(true);
        this.setDescription("Activates when Player/Mob dies");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDeath(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getCause().name().contains("CUSTOM")) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getDamager() instanceof LivingEntity)) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity().hasMetadata("ae_ignore")) {
            return;
        }
        if (entityDamageByEntityEvent.getCause().equals((Object)EntityDamageEvent.DamageCause.THORNS)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getDamager();
        LivingEntity livingEntity2 = (LivingEntity)entityDamageByEntityEvent.getEntity();
        if (livingEntity2.getHealth() - entityDamageByEntityEvent.getFinalDamage() > 0.0) {
            return;
        }
        if (livingEntity2 instanceof Player && ASManager.hasTotem((Player)livingEntity2)) {
            return;
        }
        for (StackItem stackItem : GetAllRollItems.get(livingEntity2)) {
            boolean bl = !stackItem.rit.equals((Object)RollItemType.OTHER);
            this.executionBuilder().setAttacker(livingEntity).setVictim(livingEntity2).setStackItem(stackItem).setAttackerMain(false).setEvent((Event)entityDamageByEntityEvent).setItemType(stackItem.getRollItemType()).setItem(stackItem.getItem()).setSoulboundOnly(!bl).buildAndExecute();
        }
    }
}

