/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.mechanics.triggers.internal;

import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.effects.effects.actions.AdvancedTrigger;
import net.advancedplugins.as.impl.effects.effects.actions.utils.GetAllRollItems;
import net.advancedplugins.as.impl.effects.effects.actions.utils.RollItemType;
import net.advancedplugins.as.impl.effects.effects.actions.utils.StackItem;
import net.advancedplugins.as.impl.effects.effects.effects.utils.TridentShootHandler;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class DefenseProjectileTrigger
extends AdvancedTrigger {
    public DefenseProjectileTrigger() {
        super("DEFENSE_PROJECTILE");
        this.setDescription("Activates when Player/Mob gets hit by projectile from player");
        this.setComboEnabled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileHitEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ItemStack itemStack;
        Object object;
        if (!(entityDamageByEntityEvent.getDamager() instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)entityDamageByEntityEvent.getDamager();
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity().hasMetadata("ae_ignore")) {
            return;
        }
        if (entityDamageByEntityEvent.getCause().equals((Object)EntityDamageEvent.DamageCause.THORNS)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        if (projectile instanceof Arrow) {
            if (!projectile.hasMetadata(EffectsHandler.getKey() + "handRIT")) {
                return;
            }
            object = (RollItemType)((Object)((MetadataValue)projectile.getMetadata(EffectsHandler.getKey() + "handRIT").get(0)).value());
            itemStack = player.getEquipment().getItem(((RollItemType)((Object)object)).getSlot());
        } else if (MinecraftVersion.isNew() && projectile instanceof Trident) {
            itemStack = TridentShootHandler.getItem(player.getUniqueId());
            if (itemStack == null) {
                return;
            }
        } else {
            return;
        }
        if (itemStack.getType() != Material.BOW) {
            if (!MinecraftVersion.isNew()) {
                return;
            }
            if (itemStack.getType() != Material.TRIDENT && !itemStack.getType().name().contains("CROSSBOW")) {
                return;
            }
        }
        if (projectile.hasMetadata("enchantsActivation") && !((MetadataValue)projectile.getMetadata("enchantsActivation").get(0)).asBoolean()) {
            return;
        }
        object = (LivingEntity)entityDamageByEntityEvent.getEntity();
        if (entityDamageByEntityEvent.getCause().name().equalsIgnoreCase("CUSTOM") && object.hasMetadata("mcmmo_rupture")) {
            return;
        }
        if (object instanceof Player && ((Player)object).isBlocking() && entityDamageByEntityEvent.getFinalDamage() <= 0.0) {
            return;
        }
        boolean bl = projectile.getLocation().getY() - object.getLocation().getY() > 1.45;
        this.addCombo(object.getUniqueId());
        for (StackItem stackItem : GetAllRollItems.getMainItems((LivingEntity)object)) {
            this.executionBuilder().setAttacker((LivingEntity)player).setVictim((LivingEntity)object).setStackItem(stackItem).processVariables("%is headshot%;" + bl, "%projectile type%;" + (projectile instanceof Arrow ? "arrow" : "trident")).setAttackerMain(false).setEvent((Event)entityDamageByEntityEvent).setItemType(stackItem.getRollItemType()).setItem(stackItem.getItem()).buildAndExecute();
        }
    }
}

