/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.mechanics.triggers.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.advancedplugins.as.impl.effects.armorutils.ArmorType;
import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.effects.effects.abilities.AdvancedAbility;
import net.advancedplugins.as.impl.effects.effects.actions.ActionExecution;
import net.advancedplugins.as.impl.effects.effects.actions.AdvancedTrigger;
import net.advancedplugins.as.impl.effects.effects.actions.utils.RollItemType;
import net.advancedplugins.as.impl.effects.effects.mechanics.triggers.internal.UserRepeaters;
import net.advancedplugins.as.impl.utils.SchedulerUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RepeatingTrigger
extends AdvancedTrigger {
    private static HashMap<UUID, UserRepeaters> repeaters = new HashMap();
    private static RepeatingTrigger trigger;

    public RepeatingTrigger() {
        super("REPEATING");
        this.setDescription("Repeating activation of effects");
        trigger = this;
    }

    public void activate(LivingEntity livingEntity, RollItemType rollItemType, ItemStack itemStack, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        EffectsHandler.debug("[REPEATING] Starting check for: " + livingEntity.getType());
        if (itemStack == null) {
            return;
        }
        itemStack = itemStack.clone();
        ActionExecution actionExecution = this.executionBuilder().setAttacker(livingEntity).setAttackerMain(true).setEvent(event).setItemType(rollItemType).setItem(itemStack).asRepeating().setSkipCooldown(true).skipChances().skipConditions().build();
        actionExecution.build();
        EffectsHandler.debug("[REPEATING] Found effects for " + livingEntity.getType() + " " + itemStack.getType() + ": " + actionExecution.getEffects());
        if (actionExecution.getEffects().isEmpty()) {
            return;
        }
        AdvancedAbility advancedAbility = actionExecution.getEffects().getFirst();
        if (!advancedAbility.getTypes().contains(this.getTriggerName())) {
            return;
        }
        EffectsHandler.debug("Adding repeating item: " + itemStack.getType() + " " + advancedAbility.getName() + ": s" + advancedAbility.getRepeatingDelay());
        this.addRepeatingItem(livingEntity.getUniqueId(), rollItemType, actionExecution.getEffects(), event, itemStack);
    }

    public void stop(LivingEntity livingEntity, RollItemType rollItemType, Event event) {
        UserRepeaters userRepeaters = RepeatingTrigger.getRepeaters().get(livingEntity.getUniqueId());
        if (userRepeaters == null) {
            return;
        }
        List<BukkitTask> list = userRepeaters.itemRunnables.get(rollItemType.getSlot());
        if (list == null || list.isEmpty()) {
            return;
        }
        list.forEach(BukkitTask::cancel);
    }

    private void addRepeatingItem(UUID uUID2, RollItemType rollItemType, LinkedList<AdvancedAbility> linkedList, Event event, ItemStack itemStack) {
        UserRepeaters userRepeaters = RepeatingTrigger.getRepeaters().computeIfAbsent(uUID2, uUID -> new UserRepeaters());
        ArrayList<BukkitTask> arrayList = new ArrayList<BukkitTask>();
        for (AdvancedAbility advancedAbility : linkedList) {
            Player player = Bukkit.getPlayer((UUID)uUID2);
            if (player == null) {
                player = Bukkit.getEntity((UUID)uUID2);
            }
            if (!(player instanceof LivingEntity)) continue;
            Player player2 = player;
            BukkitTask bukkitTask = new BukkitRunnable((Entity)player2, event, rollItemType, itemStack, advancedAbility){
                final /* synthetic */ Entity val$finalEntity;
                final /* synthetic */ Event val$e;
                final /* synthetic */ RollItemType val$type;
                final /* synthetic */ ItemStack val$item;
                final /* synthetic */ AdvancedAbility val$ability;
                {
                    this.val$finalEntity = entity;
                    this.val$e = event;
                    this.val$type = rollItemType;
                    this.val$item = itemStack;
                    this.val$ability = advancedAbility;
                }

                public void run() {
                    RepeatingTrigger.this.executionBuilder().setAttacker((LivingEntity)this.val$finalEntity).setAttackerMain(true).setEvent(this.val$e).setItemType(this.val$type).setItem(this.val$item).asRepeating().only(this.val$ability).buildAndExecute();
                }
            }.runTaskTimer((Plugin)EffectsHandler.getInstance(), (long)advancedAbility.getRepeatingDelay() * 20L, (long)advancedAbility.getRepeatingDelay() * 20L);
            arrayList.add(bukkitTask);
        }
        userRepeaters.itemRunnables.put(rollItemType.getSlot(), arrayList);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        UserRepeaters userRepeaters = RepeatingTrigger.getRepeaters().getOrDefault(playerQuitEvent.getPlayer().getUniqueId(), null);
        if (userRepeaters == null) {
            return;
        }
        userRepeaters.itemRunnables.forEach((equipmentSlot, list) -> list.forEach(BukkitTask::cancel));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        ArmorType.getArmorContents((LivingEntity)playerChangedWorldEvent.getPlayer()).forEach((armorType, itemStack) -> this.stop((LivingEntity)playerChangedWorldEvent.getPlayer(), armorType.getRollItemType(), (Event)playerChangedWorldEvent));
        SchedulerUtils.runTaskLater(() -> ArmorType.getArmorContents((LivingEntity)playerChangedWorldEvent.getPlayer()).forEach((armorType, itemStack) -> this.activate((LivingEntity)playerChangedWorldEvent.getPlayer(), armorType.getRollItemType(), (ItemStack)itemStack, (Event)playerChangedWorldEvent)));
    }

    public static HashMap<UUID, UserRepeaters> getRepeaters() {
        return repeaters;
    }

    public static RepeatingTrigger getTrigger() {
        return trigger;
    }
}

