/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.mechanics.triggers.internal;

import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.effects.effects.actions.AdvancedTrigger;
import net.advancedplugins.as.impl.effects.effects.actions.utils.RollItemType;
import net.advancedplugins.as.impl.effects.effects.effects.utils.TridentShootHandler;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.projectiles.ProjectileSource;

public class ShootMobTrigger
extends AdvancedTrigger {
    public ShootMobTrigger() {
        super("SHOOT_MOB");
        this.setDescription("Activates when player/mob shoots a mob");
        this.setComboEnabled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileHitEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ItemStack itemStack;
        RollItemType rollItemType;
        if (!(entityDamageByEntityEvent.getDamager() instanceof Projectile)) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity().hasMetadata("ae_ignore")) {
            return;
        }
        if (entityDamageByEntityEvent.getCause().equals((Object)EntityDamageEvent.DamageCause.THORNS)) {
            return;
        }
        Projectile projectile = (Projectile)entityDamageByEntityEvent.getDamager();
        ProjectileSource projectileSource = projectile.getShooter();
        if (!(projectileSource instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)projectileSource;
        if (projectile instanceof Arrow) {
            if (!projectile.hasMetadata(EffectsHandler.getKey() + "handRIT")) {
                return;
            }
            rollItemType = (RollItemType)((Object)((MetadataValue)projectile.getMetadata(EffectsHandler.getKey() + "handRIT").get(0)).value());
            itemStack = livingEntity.getEquipment().getItem(rollItemType.getSlot());
        } else if (MinecraftVersion.isNew() && projectile instanceof Trident) {
            itemStack = TridentShootHandler.getItem(livingEntity.getUniqueId());
            if (itemStack == null) {
                return;
            }
            rollItemType = RollItemType.HAND;
        } else {
            return;
        }
        if (itemStack.getType() != Material.BOW) {
            if (!MinecraftVersion.isNew()) {
                return;
            }
            if (itemStack.getType() != Material.TRIDENT && itemStack.getType() != Material.CROSSBOW) {
                return;
            }
        }
        if (projectile.hasMetadata("enchantsActivation") && !((MetadataValue)projectile.getMetadata("enchantsActivation").get(0)).asBoolean()) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity2 = (LivingEntity)entityDamageByEntityEvent.getEntity();
        boolean bl = entityDamageByEntityEvent.getDamager().getLocation().getY() - livingEntity2.getLocation().getY() > 1.45;
        this.addCombo(livingEntity.getUniqueId());
        this.executionBuilder().setAttacker(livingEntity).processVariables("%is headshot%;" + bl, "%projectile type%;" + (projectile instanceof Arrow ? "arrow" : "trident")).setVictim(livingEntity2).setAttackerMain(true).setEvent((Event)entityDamageByEntityEvent).setItemType(rollItemType).setItem(itemStack).buildAndExecute();
    }
}

