/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils.hooks;

import com.google.common.collect.ImmutableMap;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.PluginHookInstance;
import net.advancedplugins.as.impl.utils.hooks.holograms.CMIHologramHandler;
import net.advancedplugins.as.impl.utils.hooks.holograms.DecentHologramsHandler;
import net.advancedplugins.as.impl.utils.hooks.holograms.HologramHandler;
import net.advancedplugins.as.impl.utils.hooks.plugins.AdvancedEnchantmentsHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.AureliumSkillsHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.DynmapHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.FactionsMCoreHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.FactionsUUIDHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.GeyserHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.GriefPreventionHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.ItemsAdderHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.LandsHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.McMMOHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.MythicMobsHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.OraxenHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.PlaceholderAPIHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.ProtectionStonesHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.ResidenceHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.SlimeFunHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.SuperiorSkyblock2Hook;
import net.advancedplugins.as.impl.utils.hooks.plugins.TownyHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.WorldGuardHook;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HooksHandler {
    private static HologramHandler holograms;
    private static JavaPlugin plugin;
    private static ImmutableMap<HookPlugin, PluginHookInstance> pluginHookMap;

    public static void hook(JavaPlugin javaPlugin) {
        if (!pluginHookMap.isEmpty()) {
            pluginHookMap = ImmutableMap.builder().build();
        }
        plugin = javaPlugin;
        HooksHandler.holograms();
        if (HooksHandler.isPluginEnabled(HookPlugin.PROTOCOLLIB.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.PROTOCOLLIB, new PluginHookInstance());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.AURELIUMSKILLS.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.AURELIUMSKILLS, new AureliumSkillsHook(), true);
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.MCMMO.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.MCMMO, new McMMOHook(), true);
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.ADVANCEDENCHANTMENTS.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.ADVANCEDENCHANTMENTS, new AdvancedEnchantmentsHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.WORLDGUARD.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.WORLDGUARD, new WorldGuardHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.GRIEFPREVENTION.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.GRIEFPREVENTION, new GriefPreventionHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.PLACEHOLDERAPI.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.PLACEHOLDERAPI, new PlaceholderAPIHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.SLIMEFUN.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.SLIMEFUN, new SlimeFunHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.MYTHICMOBS.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.MYTHICMOBS, new MythicMobsHook(), true);
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.TOWNY.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.TOWNY, new TownyHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.LANDS.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.LANDS, new LandsHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.SUPERIORSKYBLOCK2.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.SUPERIORSKYBLOCK2, new SuperiorSkyblock2Hook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.ORAXEN.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.ORAXEN, new OraxenHook((Plugin)javaPlugin), true);
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.PROTECTIONSTONES.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.PROTECTIONSTONES, new ProtectionStonesHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.RESIDENCE.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.RESIDENCE, new ResidenceHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.GEYSER.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.GEYSER, new GeyserHook());
        }
        if (HooksHandler.isPluginEnabled(HookPlugin.DYNMAP.getPluginName())) {
            HooksHandler.registerNew(HookPlugin.DYNMAP, new DynmapHook());
        }
        javaPlugin.getServer().getScheduler().runTaskLater((Plugin)javaPlugin, () -> {
            if (HooksHandler.isPluginEnabled(HookPlugin.FACTIONS.getPluginName())) {
                if (HooksHandler.isPluginEnabled("MassiveCore")) {
                    HooksHandler.registerNew(HookPlugin.FACTIONS, new FactionsMCoreHook());
                } else {
                    HooksHandler.registerNew(HookPlugin.FACTIONS, new FactionsUUIDHook());
                }
            }
            if (HooksHandler.isPluginEnabled(HookPlugin.ITEMSADDER.getPluginName())) {
                HooksHandler.registerNew(HookPlugin.ITEMSADDER, new ItemsAdderHook((Plugin)javaPlugin), true);
            }
            HooksHandler.sendHookMessage(javaPlugin);
        }, 10L);
    }

    private static void sendHookMessage(JavaPlugin javaPlugin) {
        if (pluginHookMap.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (HookPlugin hookPlugin : pluginHookMap.keySet()) {
            stringBuilder.append(hookPlugin.getPluginName()).append(", ");
        }
        javaPlugin.getLogger().info("Successfully hooked into " + stringBuilder.substring(0, stringBuilder.length() - 2) + ".");
    }

    private static void registerNew(HookPlugin hookPlugin, PluginHookInstance pluginHookInstance) {
        HooksHandler.registerNew(hookPlugin, pluginHookInstance, false);
    }

    private static void registerNew(HookPlugin hookPlugin, PluginHookInstance pluginHookInstance, boolean bl) {
        pluginHookMap = ImmutableMap.builder().putAll(pluginHookMap).put((Object)hookPlugin, (Object)pluginHookInstance).build();
        if (bl) {
            plugin.getServer().getPluginManager().registerEvents((Listener)pluginHookInstance, (Plugin)plugin);
        }
    }

    public static PluginHookInstance getHook(HookPlugin hookPlugin) {
        return (PluginHookInstance)pluginHookMap.getOrDefault((Object)hookPlugin, (Object)new PluginHookInstance());
    }

    private static void holograms() {
        if (HooksHandler.isPluginEnabled("CMI")) {
            holograms = new CMIHologramHandler(plugin);
            return;
        }
        if (HooksHandler.isPluginEnabled("DecentHolograms")) {
            holograms = new DecentHologramsHandler(plugin);
            return;
        }
        if (HooksHandler.isPluginEnabled("HolographicDisplays")) {
            holograms = new DecentHologramsHandler(plugin);
            return;
        }
        holograms = new HologramHandler(plugin);
    }

    private static boolean isPluginEnabled(String string) {
        return Bukkit.getPluginManager().isPluginEnabled(string);
    }

    public static boolean isEnabled(HookPlugin hookPlugin) {
        return pluginHookMap.containsKey((Object)hookPlugin) || HooksHandler.isPluginEnabled(hookPlugin.getPluginName());
    }

    public static HologramHandler getHolograms() {
        return holograms;
    }

    static {
        pluginHookMap = ImmutableMap.builder().build();
    }
}

