/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils.hooks.plugins;

import com.gmail.nossr50.api.AbilityAPI;
import com.gmail.nossr50.api.ExperienceAPI;
import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.api.SkillAPI;
import com.gmail.nossr50.api.TreeFellerBlockBreakEvent;
import com.gmail.nossr50.datatypes.meta.BonusDropMeta;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.events.fake.FakePlayerFishEvent;
import com.gmail.nossr50.events.items.McMMOItemSpawnEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.UserManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.SchedulerUtils;
import net.advancedplugins.as.impl.utils.hooks.PluginHookInstance;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class McMMOHook
extends PluginHookInstance
implements Listener {
    public static final Map<Block, Long> treeFellerTelepathyBlocks = new HashMap<Block, Long>();

    public McMMOHook() {
        SchedulerUtils.runTaskTimer(() -> {
            long l = System.currentTimeMillis();
            treeFellerTelepathyBlocks.entrySet().removeIf(entry -> {
                if (l - (Long)entry.getValue() > 500L) {
                    ((Block)entry.getKey()).removeMetadata("ae-mcmmo-treefeller-tpdrops", (Plugin)ASManager.getInstance());
                    return true;
                }
                return false;
            });
        }, 20L, 20L);
    }

    public int getSkillLevel(Player player, String string) {
        return ExperienceAPI.getLevel((Player)player, (String)string);
    }

    public void addSkillExperience(Player player, String string, int n) {
        ExperienceAPI.addXP((Player)player, (String)string, (int)n, (String)"UNKNOWN");
    }

    public boolean isBleeding(Player player) {
        return AbilityAPI.isBleeding((LivingEntity)player);
    }

    public List<String> getSkills() {
        return SkillAPI.getSkills();
    }

    public boolean isTreeFellerEvent(Event event) {
        return event instanceof TreeFellerBlockBreakEvent;
    }

    public boolean isFakeBlockBreak(Event event) {
        return false;
    }

    public boolean isFakeFishEvent(Event event) {
        return event instanceof FakePlayerFishEvent;
    }

    public boolean callFakeEvent(Block block, Player player) {
        return true;
    }

    public void processHerbalismBlockBreakEvent(Player player, BlockBreakEvent blockBreakEvent) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer((Player)player);
        if (mcMMOPlayer == null) {
            return;
        }
        mcMMOPlayer.getHerbalismManager().processHerbalismBlockBreakEvent(blockBreakEvent);
    }

    public boolean blockHasHerbalismBonusDrops(Block block) {
        return block.hasMetadata("mcMMO: Double Drops");
    }

    public boolean hasHerbalismSkill(Player player) {
        return mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.HERBALISM);
    }

    public int getHerbalismBonusDropMultiplier(Block block) {
        BonusDropMeta bonusDropMeta = (BonusDropMeta)block.getMetadata("mcMMO: Double Drops").get(0);
        return bonusDropMeta.asInt();
    }

    @Override
    public String getName() {
        return "mcMMO";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onTelepathyTreeFellerBonusItemSpawn(McMMOItemSpawnEvent mcMMOItemSpawnEvent) {
        Block block = mcMMOItemSpawnEvent.getLocation().getBlock();
        if (!treeFellerTelepathyBlocks.containsKey(block)) {
            return;
        }
        mcMMOItemSpawnEvent.setCancelled(true);
        if (mcMMOItemSpawnEvent.getItemSpawnReason() == ItemSpawnReason.BONUS_DROPS) {
            ASManager.giveItem(mcMMOItemSpawnEvent.getPlayer(), mcMMOItemSpawnEvent.getItemStack());
        }
    }
}

