/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils.hooks.plugins;

import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.events.noteblock.OraxenNoteBlockBreakEvent;
import io.th0rgal.oraxen.utils.drops.Loot;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.PluginHookInstance;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class OraxenHook
extends PluginHookInstance
implements Listener {
    private final Plugin plugin;

    public OraxenHook(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return HookPlugin.ITEMSADDER.getPluginName();
    }

    public boolean isCustomBlock(Block block) {
        return OraxenBlocks.isOraxenBlock((Block)block);
    }

    public boolean isCustomStringBlock(Block block) {
        return OraxenBlocks.isOraxenStringBlock((Block)block);
    }

    public boolean isCustomNoteBlock(Block block) {
        return OraxenBlocks.isOraxenNoteBlock((Block)block);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onCustomBlockBreak(OraxenNoteBlockBreakEvent oraxenNoteBlockBreakEvent) {
        Block block = oraxenNoteBlockBreakEvent.getBlock();
        if (block.hasMetadata("ae-oraxen-cancel")) {
            block.removeMetadata("ae-oraxen-cancel", this.plugin);
            oraxenNoteBlockBreakEvent.setCancelled(true);
        }
    }

    public boolean canBeBrokenWith(ItemStack itemStack, Block block) {
        if (this.isCustomNoteBlock(block)) {
            return OraxenBlocks.getNoteBlockMechanic((Block)block).getDrop().isToolEnough(itemStack);
        }
        if (this.isCustomStringBlock(block)) {
            return OraxenBlocks.getStringMechanic((Block)block).getDrop().isToolEnough(itemStack);
        }
        return false;
    }

    public List<ItemStack> getLootForCustomBlock(Block block) {
        if (this.isCustomNoteBlock(block)) {
            return OraxenBlocks.getNoteBlockMechanic((Block)block).getDrop().getLoots().stream().map(Loot::getItemStack).collect(Collectors.toList());
        }
        if (this.isCustomStringBlock(block)) {
            return OraxenBlocks.getStringMechanic((Block)block).getDrop().getLoots().stream().map(Loot::getItemStack).collect(Collectors.toList());
        }
        return new ArrayList<ItemStack>();
    }

    public boolean removeBlock(Block block) {
        if (!this.isCustomBlock(block)) {
            return false;
        }
        return OraxenBlocks.remove((Location)block.getLocation(), null);
    }
}

