/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils.items;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.ColorUtils;
import net.advancedplugins.as.impl.utils.MathUtils;
import net.advancedplugins.as.impl.utils.Pair;
import net.advancedplugins.as.impl.utils.SkullCreator;
import net.advancedplugins.as.impl.utils.VanillaEnchants;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.HooksHandler;
import net.advancedplugins.as.impl.utils.hooks.plugins.ItemsAdderHook;
import net.advancedplugins.as.impl.utils.items.ItemBuilder;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigItemCreator {
    private static HashMap<String, String> cfgPaths = null;

    public static void setDefaultPaths(HashMap<String, String> hashMap) {
        cfgPaths = hashMap;
    }

    public static ItemStack fromConfigSection(String string, String string2, Map<String, String> map, Map<String, String> map2, JavaPlugin javaPlugin) {
        File file = new File(javaPlugin.getDataFolder().getAbsolutePath() + File.separator + string);
        if (!file.exists()) {
            ConfigItemCreator.sendError("Unknown file!", string, null, null);
            return new ItemStack(Material.AIR);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        return ConfigItemCreator.fromConfigSection((FileConfiguration)yamlConfiguration, string2, map, map2);
    }

    public static ItemStack fromConfigSection(FileConfiguration fileConfiguration, ItemStack itemStack, String string, Map<String, String> map, Map<String, String> map2) {
        return ConfigItemCreator.fromConfigSection(fileConfiguration.getConfigurationSection(""), itemStack, string, map, map2);
    }

    public static ItemStack fromConfigSection(ConfigurationSection configurationSection, ItemStack itemStack, String string, Map<String, String> map, Map<String, String> map2) {
        boolean bl;
        String[] stringArray;
        String n3;
        String[] n;
        Map map3 = (Map)cfgPaths.clone();
        String string3 = "config";
        if (map2 != null && !map2.isEmpty()) {
            for (Map.Entry object2 : map2.entrySet()) {
                map3.put((String)object2.getKey(), (String)object2.getValue());
            }
        }
        ItemBuilder itemBuilder = new ItemBuilder(itemStack);
        String string2 = itemBuilder.toItemStack().getType().name();
        if (configurationSection.contains(string + "." + (String)map3.get("name"))) {
            n = ConfigItemCreator.format(configurationSection.getString(string + "." + (String)map3.get("name"), null), map);
            itemBuilder.setName((String)n);
        }
        if (configurationSection.contains(string + "." + (String)map3.get("lore"))) {
            n = ConfigItemCreator.format(configurationSection.getStringList(string + "." + (String)map3.get("lore")), map);
            itemBuilder.setLore((List<String>)n);
        }
        if (configurationSection.contains(string + "." + (String)map3.get("item-flags"))) {
            n = ConfigItemCreator.format(configurationSection.getStringList(string + "." + (String)map3.get("item-flags")), map);
            for (String n4 : n) {
                boolean bl2 = false;
                n3 = n4.toUpperCase(Locale.ROOT);
                for (ItemFlag itemFlag : ItemFlag.values()) {
                    if (!itemFlag.name().equals(n3)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    ConfigItemCreator.sendError("Specified ItemFlag doesn't exist!", string3, string, n4);
                    continue;
                }
                itemBuilder.addItemFlag(ItemFlag.valueOf((String)n4));
            }
        }
        if (configurationSection.contains(string + "." + (String)map3.get("armor-trim"))) {
            String n4;
            n = configurationSection.getString(string + "." + (String)map3.get("armor-trim")).split(";");
            stringArray = n[0];
            n4 = n[1];
            itemBuilder.setArmorTrim((String)stringArray, n4);
        }
        if (configurationSection.contains(string + "." + (String)map3.get("custom-model-data")) && MinecraftVersion.getVersionNumber() >= 1140) {
            int list = configurationSection.getInt(string + "." + (String)map3.get("custom-model-data"));
            itemBuilder.setCustomModelData(list);
        }
        if (configurationSection.contains(string + "." + (String)map3.get("unbreakable"))) {
            itemBuilder.setUnbreakable(configurationSection.getBoolean(string + "." + (String)map3.get("unbreakable")));
        }
        if (configurationSection.contains(string + "." + (String)map3.get("enchantments"))) {
            List<String> list = ConfigItemCreator.format(configurationSection.getStringList(string + "." + (String)map3.get("enchantments")), map);
            for (String n4 : list) {
                Pair<String, Integer> pair = ASManager.parseEnchantment(n4);
                if (pair == null) continue;
                n3 = VanillaEnchants.displayNameToEnchant(pair.getKey());
                if (n3 == null) {
                    ConfigItemCreator.sendError("Specified vanilla enchantment doesn't exist!", string3, string, pair.getKey());
                    continue;
                }
                itemBuilder.addUnsafeEnchantment((Enchantment)n3, pair.getValue());
            }
        }
        if (configurationSection.contains(string + "." + (String)map3.get("custom-enchantments"))) {
            List<String> string5 = ConfigItemCreator.format(configurationSection.getStringList(string + "." + (String)map3.get("custom-enchantments")), map);
            for (String n4 : string5) {
                Pair<String, Integer> n2 = ASManager.parseEnchantment(n4);
                if (n2 == null) continue;
                itemBuilder.addCustomEnchantment(n2.getKey(), n2.getValue());
            }
        }
        if ((string2.contains("LEATHER_") || string2.contains("FIREWORK_STAR")) && configurationSection.contains(string + "." + (String)map3.get("rgb-color"))) {
            String bl3 = ConfigItemCreator.format(configurationSection.getString(string + "." + (String)map3.get("rgb-color")), map);
            stringArray = bl3.split(";");
            if (stringArray.length != 3) {
                ConfigItemCreator.sendError("RGB color must contain 3 values in the format \"255;255;255\"!", string3, string, bl3);
                return new ItemStack(Material.AIR);
            }
            if (!(MathUtils.isInteger(stringArray[0]) && MathUtils.isInteger(stringArray[1]) && MathUtils.isInteger(stringArray[2]))) {
                ConfigItemCreator.sendError("RGB values must be between 0-255!", string3, string, stringArray[0]);
                return new ItemStack(Material.AIR);
            }
            int n2 = MathUtils.clamp(Integer.parseInt(stringArray[0]), 0, 255);
            int n4 = MathUtils.clamp(Integer.parseInt(stringArray[1]), 0, 255);
            int n5 = MathUtils.clamp(Integer.parseInt(stringArray[2]), 0, 255);
            Color color = Color.fromRGB((int)n2, (int)n4, (int)n5);
            if (string2.contains("LEATHER_")) {
                itemBuilder.setColor(color);
            } else if (string2.contains("FIREWORK_STAR")) {
                FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)itemBuilder.getItemMeta();
                fireworkEffectMeta.setEffect(FireworkEffect.builder().withColor(color).build());
            }
        }
        if (configurationSection.contains(string + "." + (String)map3.get("force-glow")) && (bl = configurationSection.getBoolean(string + "." + (String)map3.get("force-glow")))) {
            itemBuilder.setGlowing(true);
        }
        return itemBuilder.toItemStack();
    }

    public static ItemStack fromConfigSection(FileConfiguration fileConfiguration, String string, Map<String, String> map, Map<String, String> map2) {
        return ConfigItemCreator.fromConfigSection(fileConfiguration.getConfigurationSection(""), string, map, map2);
    }

    public static ItemStack fromConfigSection(ConfigurationSection configurationSection, String string, Map<String, String> map, Map<String, String> map2) {
        Map.Entry<String, String> entry;
        Object object;
        String string2 = "config";
        Map map3 = (Map)cfgPaths.clone();
        if (map2 != null && !map2.isEmpty()) {
            object = map2.entrySet().iterator();
            while (object.hasNext()) {
                entry = object.next();
                map3.put(entry.getKey(), entry.getValue());
            }
        }
        entry = (object = configurationSection.getString(string + "." + (String)map3.get("type"), null)) != null ? ConfigItemCreator.format((String)object, map) : null;
        byte by = (byte)configurationSection.getInt(string + "." + (String)map3.get("id"));
        int n = MathUtils.clamp(ASManager.parseInt(configurationSection.getString(string + "." + (String)map3.get("amount"), "1"), 1), 1, 64);
        Object object2 = configurationSection.get(string + ".advanced-heads");
        String string3 = configurationSection.getString(string + "." + (String)map3.get("head"));
        String string4 = configurationSection.getString(string + "." + (String)map3.get("itemsadder"));
        ItemStack itemStack = string4 != null ? ((ItemsAdderHook)HooksHandler.getHook(HookPlugin.ITEMSADDER)).getByName(string4) : (string3 != null ? SkullCreator.itemFromBase64(string3) : ASManager.matchMaterial(entry, n, by));
        if (itemStack == null) {
            ConfigItemCreator.sendError("Specified material doesn't exist!", string2, string, entry);
            return new ItemStack(Material.AIR);
        }
        return ConfigItemCreator.fromConfigSection(configurationSection, itemStack, string, map, map2);
    }

    private static String format(String string, Map<String, String> map) {
        string = ConfigItemCreator.placeholders(string, map);
        string = ColorUtils.format(string);
        return string;
    }

    private static List<String> format(List<String> list, Map<String, String> map) {
        return ColorUtils.format(ConfigItemCreator.placeholders(list, map));
    }

    private static String placeholders(String string, Map<String, String> map) {
        if (map != null && string != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                int n;
                StringBuilder stringBuilder;
                String[] stringArray;
                String string2;
                if (string.contains("%description%") && entry.getKey().contains("%description%") && entry.getValue().contains("\n")) {
                    string2 = string;
                    string = "";
                    stringArray = entry.getValue().split("\n");
                    stringBuilder = new StringBuilder(string);
                    for (n = 0; n < stringArray.length; ++n) {
                        stringBuilder.append(string2.replace(entry.getKey(), stringArray[n]));
                        if (n + 1 == stringArray.length) continue;
                        stringBuilder.append("\n");
                    }
                    string = stringBuilder.toString();
                    continue;
                }
                if (string.contains("%level-description%") && entry.getKey().contains("%level-description%") && entry.getValue().contains("\n")) {
                    string2 = string;
                    string = "";
                    stringArray = entry.getValue().split("\n");
                    stringBuilder = new StringBuilder(string);
                    for (n = 0; n < stringArray.length; ++n) {
                        stringBuilder.append(string2.replace(entry.getKey(), stringArray[n]));
                        if (n + 1 == stringArray.length) continue;
                        stringBuilder.append("\n");
                    }
                    string = stringBuilder.toString();
                    continue;
                }
                string = string.replace(entry.getKey(), entry.getValue());
            }
        }
        return string;
    }

    private static List<String> placeholders(List<String> list, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (map != null) {
            for (String string : list) {
                if ((string = ConfigItemCreator.placeholders(string, map)).contains("\n")) {
                    String[] stringArray = string.split("\\n");
                    String string2 = "";
                    for (String string3 : stringArray) {
                        arrayList.add(string2 + string3);
                        string2 = ColorUtils.getLastColor(string3);
                    }
                    continue;
                }
                arrayList.add(string);
            }
        } else {
            return list;
        }
        return arrayList;
    }

    private static String addPunctuation(String string) {
        boolean bl;
        boolean bl2 = bl = string.endsWith(".") || string.endsWith("!") || string.endsWith("?");
        if (!bl) {
            string = string + ".";
        }
        return string;
    }

    private static void sendError(String string, String string2, String string3, Object object) {
        Bukkit.getLogger().severe("Something went wrong while creating an item! " + ConfigItemCreator.addPunctuation(string) + " File: " + string2 + "  Config Path: " + string3 + "  Value: " + object);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "type");
        hashMap.put("id", "id");
        hashMap.put("amount", "amount");
        hashMap.put("name", "name");
        hashMap.put("lore", "lore");
        hashMap.put("item-flags", "item-flags");
        hashMap.put("custom-model-data", "custom-model-data");
        hashMap.put("force-glow", "force-glow");
        hashMap.put("enchantments", "enchantments");
        hashMap.put("custom-enchantments", "custom-enchantments");
        hashMap.put("rgb-color", "rgb-color");
        hashMap.put("itemsadder", "itemsadder");
        hashMap.put("armor-trim", "armor-trim");
        hashMap.put("unbreakable", "unbreakable");
        hashMap.put("head", "head");
        hashMap.put("owner", "head");
        ConfigItemCreator.setDefaultPaths(hashMap);
    }
}

