/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils.nbt.utils;

import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public enum MinecraftVersion {
    Unknown(Integer.MAX_VALUE),
    MC1_7_R4(174),
    MC1_8_R3(183),
    MC1_9_R1(191),
    MC1_9_R2(192),
    MC1_10_R1(1101),
    MC1_11_R1(1111),
    MC1_12_R1(1121),
    MC1_13_R1(1131),
    MC1_13_R2(1132),
    MC1_14_R1(1141),
    MC1_15_R1(1150),
    MC1_16_R1(1160),
    MC1_16_R2(1161),
    MC1_16_R3(1163),
    MC1_17_R1(1170),
    MC1_18_R1(1180, true),
    MC1_18_R2(1182, true),
    MC1_19_R1(1191, true),
    MC1_19_R2(1192, true),
    MC1_19_R3(1194, true),
    MC1_20_R1(1201, true),
    MC1_20_R2(1202, true),
    MC1_20_R3(1203, true),
    MC1_20_R4(1204, true);

    private final int versionId;
    public final boolean mojangMapping;
    private static MinecraftVersion version;
    private static Boolean hasGsonSupport;
    private static Boolean isPaper;

    private MinecraftVersion(int n2) {
        this(n2, false);
    }

    private MinecraftVersion(int n2, boolean bl) {
        this.versionId = n2;
        this.mojangMapping = bl;
    }

    public static MinecraftVersion init() {
        if (version != null) {
            return version;
        }
        String string = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        isPaper = Package.getPackage("com.destroystokyo.paper") != null;
        try {
            version = MinecraftVersion.valueOf(string.replace("v", "MC"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            version = Unknown;
        }
        if (version == Unknown) {
            Bukkit.getServer().getLogger().warning("You are using invalid version of Minecraft [" + string + "]! Disabling...");
        }
        return version;
    }

    public static boolean isNew() {
        return MinecraftVersion.getVersionNumber() >= 1130;
    }

    public static boolean isPaper() {
        return isPaper;
    }

    public static MinecraftVersion getVersion() {
        return version;
    }

    public static int getVersionNumber() {
        return MinecraftVersion.version.versionId;
    }

    public static MinecraftVersion getCurrentVersion() {
        return version;
    }

    public boolean isMojangMapping() {
        return this.mojangMapping;
    }

    public String getPackageName() {
        if (MinecraftVersion.getVersion() == Unknown) {
            return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        return this.name().replace("MC", "v");
    }

    public int getVersionId() {
        return this.versionId;
    }

    public static boolean hasGsonSupport() {
        if (hasGsonSupport != null) {
            return hasGsonSupport;
        }
        try {
            hasGsonSupport = true;
        }
        catch (Exception exception) {
            hasGsonSupport = false;
        }
        return hasGsonSupport;
    }

    public static boolean isAtLeastVersion(MinecraftVersion minecraftVersion) {
        return MinecraftVersion.getVersion().getVersionId() >= minecraftVersion.getVersionId();
    }

    public static boolean isNewerThan(MinecraftVersion minecraftVersion) {
        return MinecraftVersion.getVersion().getVersionId() > minecraftVersion.getVersionId();
    }

    public static void disableDuplicateUUIDReporting(JavaPlugin javaPlugin) {
    }
}

