/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.ZipFile;
import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.Registry;
import net.advancedplugins.as.impl.utils.RunnableMetrics;
import net.advancedplugins.as.impl.utils.commands.CommandBase;
import net.advancedplugins.as.impl.utils.economy.EconomyHandler;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.HooksHandler;
import net.advancedplugins.as.impl.utils.menus.AdvancedMenusHandler;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.as.impl.utils.plugin.AdvancedPlugin;
import net.advancedplugins.as.impl.utils.protection.ProtectionHandler;
import net.advancedplugins.localization.LocaleHandler;
import net.advancedplugins.seasons.biomes.BiomesHandler;
import net.advancedplugins.seasons.commands.ASCommand;
import net.advancedplugins.seasons.commands.CalendarCommand;
import net.advancedplugins.seasons.commands.SeasonShopCommand;
import net.advancedplugins.seasons.enums.Season;
import net.advancedplugins.seasons.handlers.CalendarHandler;
import net.advancedplugins.seasons.handlers.CropsHandler;
import net.advancedplugins.seasons.handlers.SeasonEventsHandler;
import net.advancedplugins.seasons.handlers.SeasonHandler;
import net.advancedplugins.seasons.handlers.SeasonalMobsHandler;
import net.advancedplugins.seasons.handlers.WeatherHandler;
import net.advancedplugins.seasons.handlers.WorldHandler;
import net.advancedplugins.seasons.handlers.bedrock.BedrockHandler;
import net.advancedplugins.seasons.handlers.sub.BlockProcessHandler;
import net.advancedplugins.seasons.listeners.ChunkExitListener;
import net.advancedplugins.seasons.listeners.SleepListener;
import net.advancedplugins.seasons.temperature.TemperatureEventTrigger;
import net.advancedplugins.seasons.temperature.TemperatureHandler;
import net.advancedplugins.seasons.utils.PAPIPlaceholders;
import net.advancedplugins.seasons.utils.ShopMenuConfig;
import net.advancedplugins.seasons.visuals.VisualsHandler;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Core
extends AdvancedPlugin {
    private static BiomesHandler biomesHandler;
    private static SeasonHandler seasonHandler;
    private static LocaleHandler localeHandler;
    private static TemperatureHandler temperatureHandler;
    private static CalendarHandler calendarHandler;
    private static AdvancedMenusHandler menusHandler;
    private static BlockProcessHandler blockProcessHandler;
    private static VisualsHandler visualsHandler;
    private static CropsHandler cropsHandler;
    private static WeatherHandler weatherHandler;
    private static SeasonalMobsHandler seasonalMobsHandler;
    private static SeasonEventsHandler eventsHandler;
    private static ShopMenuConfig shopMenuConfig;
    private static EconomyHandler economyHandler;
    private static WorldHandler worldHandler;
    private static ProtectionHandler protectionHandler;
    private static BedrockHandler bedrockHandler;
    private static EffectsHandler effectsHandler;
    private String lastId = "";
    private String serverUUID;
    public static boolean Bukkit;
    private boolean lastTime = false;

    public static String readZipComment(File file) {
        String string;
        ZipFile zipFile = new ZipFile(file);
        try {
            string = zipFile.getComment();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "";
            }
        }
        zipFile.close();
        return string;
    }

    @Override
    public void startup() {
        this.saveDefaultConfig();
        this.reloadConfig();
        MinecraftVersion.init();
        new RunnableMetrics((Plugin)this, 20520);
        Season.initializeTransitions();
        this.registerEvents(new ChunkExitListener());
        this.registerEvents(new SleepListener());
        HooksHandler.hook(this);
        if (!HooksHandler.isEnabled(HookPlugin.PROTOCOLLIB)) {
            this.getServer().getLogger().severe("============================================================================");
            this.getServer().getLogger().severe("ProtocolLib is required for AdvancedSeasons to work. Plugin is now disabling.");
            this.getServer().getLogger().severe("Follow the installation guide here: https://seasons.advancedplugins.net/first-install");
            this.getServer().getLogger().severe("============================================================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerAbilities();
        this.init();
        CommandBase commandBase = new CommandBase(this);
        commandBase.registerCommand(new CalendarCommand(this));
        commandBase.registerCommand(new SeasonShopCommand(this));
        commandBase.registerCommand(new ASCommand(Core.getInstance()));
        try {
            this.lastId = Registry.get();
            new BukkitRunnable(){
                int conCount = 0;

                public void run() {
                    try {
                        int n;
                        InputStream inputStream;
                        String string = Registry.get();
                        if (string == null) {
                            Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                        }
                        if ((inputStream = AdvancedPlugin.getInstance().getResource(".key")) != null) {
                            try {
                                int n2;
                                String string2 = (String)new BufferedReader(new InputStreamReader(inputStream)).lines().iterator().next();
                                if (string2.length() != 32) {
                                    Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                                    return;
                                }
                                Core.this.lastId = string2;
                                Core.this.serverUUID = RunnableMetrics.getServerUUID();
                                int n3 = Core.this.getServer().getOnlinePlayers().size();
                                String string3 = "https://v2.advancedplugins.net/auth/handshake.php?token=%token%&server=%serverUUID%&playerCount=%playerCount%";
                                string3 = string3.replace("%token%", string2);
                                string3 = string3.replace("%serverUUID%", Core.this.serverUUID);
                                string3 = string3.replace("%playerCount%", Integer.toString(n3));
                                URL uRL = new URL(string3);
                                URLConnection uRLConnection = uRL.openConnection();
                                uRLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                                InputStream inputStream2 = uRLConnection.getInputStream();
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                byte[] byArray = new byte[16384];
                                while ((n2 = inputStream2.read(byArray, 0, byArray.length)) != -1) {
                                    byteArrayOutputStream.write(byArray, 0, n2);
                                }
                                Gson gson = new Gson();
                                String string4 = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                                Map map = (Map)gson.fromJson(string4, Map.class);
                                Double d = (Double)map.get("code");
                                if (d == 1.0) {
                                    Bukkit = true;
                                    this.conCount = 0;
                                } else {
                                    Core.this.getServer().getLogger().warning("[AdvancedSeasons] " + map.get("message"));
                                    Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                                }
                            }
                            catch (Exception exception) {
                                if (Bukkit && this.conCount < 2) {
                                    Core.this.getLogger().info("Failed to connect to authentication server - retrying later.");
                                    ++this.conCount;
                                }
                                exception.printStackTrace();
                                Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                            }
                            return;
                        }
                        if (Core.this.lastId.isEmpty() && string.isEmpty()) {
                            Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                        }
                        if (string.length() > 7) {
                            Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                        }
                        try {
                            Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                        }
                        Core.this.lastId = string;
                        String string5 = "http://servers.advancedmarket.co/seasons/apitest.php?&userId=%id%&minecraftVersion=%mc%&aeVersion=%ae%&re=%re%&playerCount=%playerCount%";
                        String string6 = "" + MinecraftVersion.getVersionNumber();
                        string5 = string5.replace("%mc%", (CharSequence)(MinecraftVersion.getVersionNumber() >= 1100 ? string6.substring(0, string6.length() - 1) : string6));
                        string5 = string5.replace("%ae%", "1.0.0");
                        string5 = string5.replace("%id%", string);
                        string5 = string5.replace("%re%", "" + Bukkit);
                        string5 = string5.replace("%playerCount%", "" + Core.this.getServer().getOnlinePlayers().size());
                        URL uRL = new URL(string5);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                        InputStream inputStream3 = uRLConnection.getInputStream();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = new byte[16384];
                        while ((n = inputStream3.read(byArray, 0, byArray.length)) != -1) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                        String string7 = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                        int n4 = Integer.parseInt(string7.replaceAll("[^0-9]", ""));
                        switch (n4) {
                            case 1: {
                                Bukkit = true;
                                return;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                Core.this.getServer().getLogger().info("[AdvancedSeasons] Could not initialise plugin, are you using Vault?");
                                Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                                return;
                            }
                            case 4: {
                                Core.this.getServer().getLogger().warning("[AdvancedSeasons] Could not initialise plugin, contact developer with code 126");
                                Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                                return;
                            }
                            case 5: {
                                Core.this.getServer().getLogger().warning("[AdvancedSeasons] Your license exceeded maximum number of unique IPs. Contact the developer for an enterprise license or connect using previously used IPs.");
                                Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                                return;
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (Core.this.lastTime) {
                            Core.this.lastTime = false;
                        } else {
                            Core.this.getServer().getLogger().warning("[AdvancedSeasons] Failed to connect to remote server, is your firewall configured properly?");
                        }
                        Bukkit = true;
                        return;
                    }
                    Core.this.getServer().getLogger().warning("[AdvancedSeasons] Could not initialise plugin, contact developer with code 002, your ID: " + Core.this.lastId);
                    Core.this.getServer().getPluginManager().disablePlugin((Plugin)AdvancedPlugin.getInstance());
                }
            }.runTask((Plugin)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)Core.getInstance());
        }
        if (!Registry.get().equalsIgnoreCase(this.lastId)) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.setLoaded(true);
    }

    private void registerAbilities() {
        effectsHandler = new EffectsHandler("seasons", this, actionExecutionBuilder -> Core.getTemperatureHandler().getAbilities().getTemperatureEffects((Player)actionExecutionBuilder.getMain()));
        EffectsHandler.getTriggerHandler().getTriggers().forEach(advancedTrigger -> advancedTrigger.setEnabled(false));
        EffectsHandler.getTriggerHandler().register(this, new TemperatureEventTrigger());
    }

    public void init() {
        String[] stringArray;
        if (this.isLoaded()) {
            menusHandler.unload();
            this.unload();
            temperatureHandler.unload();
            weatherHandler.unload();
        }
        worldHandler = new WorldHandler(this);
        for (String string : stringArray = new String[]{"badlands_deserts.yml", "forests.yml", "jungles.yml", "oceans_beaches.yml", "plains_meadows.yml", "rivers_shores.yml", "savannas_hills.yml", "swamps_mangroves.yml", "taigas_snowy.yml"}) {
            ASManager.saveResource("biomeConfiguration/" + string);
        }
        if (!this.isLoaded()) {
            biomesHandler = new BiomesHandler(this);
        }
        economyHandler = new EconomyHandler(this);
        bedrockHandler = new BedrockHandler(this);
        localeHandler = new LocaleHandler(this);
        localeHandler.readLocaleFiles(this, "lang");
        localeHandler.setLocale(this.getConfig().getString("locale"));
        localeHandler.setPrefix("prefix");
        seasonHandler = new SeasonHandler(this);
        temperatureHandler = new TemperatureHandler(this);
        calendarHandler = new CalendarHandler(this);
        menusHandler = new AdvancedMenusHandler(this);
        blockProcessHandler = new BlockProcessHandler(this);
        visualsHandler = new VisualsHandler(this);
        cropsHandler = new CropsHandler(this);
        weatherHandler = new WeatherHandler(this);
        seasonalMobsHandler = new SeasonalMobsHandler(this);
        eventsHandler = new SeasonEventsHandler(this);
        shopMenuConfig = new ShopMenuConfig(this);
        protectionHandler = new ProtectionHandler(this);
        if (HooksHandler.isEnabled(HookPlugin.PLACEHOLDERAPI)) {
            new PAPIPlaceholders();
        }
    }

    @Override
    public void unload() {
        if (calendarHandler == null) {
            return;
        }
        calendarHandler.unload();
        blockProcessHandler.stopTasks();
        visualsHandler.unload();
        weatherHandler.unload();
    }

    public static BiomesHandler getBiomesHandler() {
        return biomesHandler;
    }

    public static SeasonHandler getSeasonHandler() {
        return seasonHandler;
    }

    public static LocaleHandler getLocaleHandler() {
        return localeHandler;
    }

    public static TemperatureHandler getTemperatureHandler() {
        return temperatureHandler;
    }

    public static CalendarHandler getCalendarHandler() {
        return calendarHandler;
    }

    public static AdvancedMenusHandler getMenusHandler() {
        return menusHandler;
    }

    public static BlockProcessHandler getBlockProcessHandler() {
        return blockProcessHandler;
    }

    public static VisualsHandler getVisualsHandler() {
        return visualsHandler;
    }

    public static CropsHandler getCropsHandler() {
        return cropsHandler;
    }

    public static WeatherHandler getWeatherHandler() {
        return weatherHandler;
    }

    public static SeasonalMobsHandler getSeasonalMobsHandler() {
        return seasonalMobsHandler;
    }

    public static SeasonEventsHandler getEventsHandler() {
        return eventsHandler;
    }

    public static ShopMenuConfig getShopMenuConfig() {
        return shopMenuConfig;
    }

    public static EconomyHandler getEconomyHandler() {
        return economyHandler;
    }

    public static WorldHandler getWorldHandler() {
        return worldHandler;
    }

    public static ProtectionHandler getProtectionHandler() {
        return protectionHandler;
    }

    public static BedrockHandler getBedrockHandler() {
        return bedrockHandler;
    }

    public static EffectsHandler getEffectsHandler() {
        return effectsHandler;
    }

    static {
        Bukkit = false;
    }
}

