/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.biomes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.seasons.biomes.AdvancedBiomeBase;
import net.advancedplugins.seasons.biomes.BiomesHandler;
import net.advancedplugins.seasons.enums.Season;
import net.advancedplugins.seasons.enums.SeasonType;
import org.bukkit.block.Biome;

public class BiomeUtils {
    private static ImmutableList<Integer> fallNoMixBiomes;
    private static ImmutableList<Biome> noSnowBiomes;
    private static final ImmutableList<String> snowyBiomes;

    public static void init(BiomesHandler biomesHandler) {
        BiomeUtils.generateFallNoMixBiomes(biomesHandler.getOptimizedIDs());
        BiomeUtils.generateNoSnowBiomes(biomesHandler);
    }

    private static void generateNoSnowBiomes(BiomesHandler biomesHandler) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Biome biome : Biome.values()) {
            AdvancedBiomeBase advancedBiomeBase = biomesHandler.getBiome(biome);
            if (advancedBiomeBase == null || advancedBiomeBase.getSeasons().get((Object)SeasonType.WINTER).getWinterFreeze().booleanValue()) continue;
            builder.add((Object)biome);
        }
        noSnowBiomes = builder.build();
    }

    private static void generateFallNoMixBiomes(ImmutableMap<Integer, Biome> immutableMap) {
        fallNoMixBiomes = ImmutableList.builder().add((Object)ASManager.getKeyByValue(immutableMap, Biome.SAVANNA_PLATEAU)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.SAVANNA)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.OCEAN)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.RIVER)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.FROZEN_RIVER)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.COLD_OCEAN)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.DEEP_COLD_OCEAN)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.DEEP_FROZEN_OCEAN)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.WARM_OCEAN)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.LUKEWARM_OCEAN)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.DEEP_LUKEWARM_OCEAN)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.BEACH)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.DESERT)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.JUNGLE)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.SPARSE_JUNGLE)).add((Object)ASManager.getKeyByValue(immutableMap, Biome.BAMBOO_JUNGLE)).build();
    }

    public static Season getTransitionEnum(SeasonType seasonType, int n) {
        if (n > 3) {
            switch (seasonType) {
                case SPRING: {
                    return Season.SUMMER;
                }
                case SUMMER: {
                    return Season.FALL;
                }
                case FALL: {
                    return Season.WINTER;
                }
                case WINTER: {
                    return Season.SPRING;
                }
            }
            return null;
        }
        switch (seasonType) {
            case SPRING: {
                switch (n) {
                    case 0: {
                        return Season.SPRING;
                    }
                    case 1: {
                        return Season.SPRING_TRANSITION_1;
                    }
                    case 2: {
                        return Season.SPRING_TRANSITION_2;
                    }
                    case 3: {
                        return Season.SPRING_TRANSITION_3;
                    }
                }
            }
            case SUMMER: {
                switch (n) {
                    case 0: {
                        return Season.SUMMER;
                    }
                    case 1: {
                        return Season.SUMMER_TRANSITION_1;
                    }
                    case 2: {
                        return Season.SUMMER_TRANSITION_2;
                    }
                    case 3: {
                        return Season.SUMMER_TRANSITION_3;
                    }
                }
            }
            case FALL: {
                switch (n) {
                    case 0: {
                        return Season.FALL;
                    }
                    case 1: {
                        return Season.FALL_TRANSITION_1;
                    }
                    case 2: {
                        return Season.FALL_TRANSITION_2;
                    }
                    case 3: {
                        return Season.FALL_TRANSITION_3;
                    }
                }
            }
            case WINTER: {
                switch (n) {
                    case 0: {
                        return Season.WINTER;
                    }
                    case 1: {
                        return Season.WINTER_TRANSITION_1;
                    }
                    case 2: {
                        return Season.WINTER_TRANSITION_2;
                    }
                    case 3: {
                        return Season.WINTER_TRANSITION_3;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Invalid season or transition");
    }

    public static SeasonType getSeasonType(int n) {
        return Arrays.stream(Season.values()).filter(season -> season.getSeasonId() == n).findFirst().get().getType();
    }

    public static ImmutableList<Integer> getFallNoMixBiomes() {
        return fallNoMixBiomes;
    }

    public static ImmutableList<Biome> getNoSnowBiomes() {
        return noSnowBiomes;
    }

    public static ImmutableList<String> getSnowyBiomes() {
        return snowyBiomes;
    }

    static {
        snowyBiomes = ImmutableList.of((Object)"SNOWY_PLAINS", (Object)"SNOWY_SLOPES", (Object)"SNOWY_BEACH", (Object)"SNOWY_TAIGA", (Object)"ICE_SPIKES", (Object)"FROZEN_RIVER", (Object)"FROZEN_PEAKS", (Object)"FROZEN_OCEAN", (Object)"DEEP_FROZEN_OCEAN");
    }
}

