/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.handlers;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.DataHandler;
import net.advancedplugins.seasons.Core;
import net.advancedplugins.seasons.biomes.AdvancedBiomeBase;
import net.advancedplugins.seasons.enums.SeasonType;
import net.advancedplugins.seasons.handlers.sub.SeasonMobs;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class SeasonalMobsHandler
extends DataHandler
implements Listener {
    private ImmutableMap<SeasonType, SeasonMobs> seasonMobs;
    private final int spawnChance = this.getConfig().getInt("chance", 30);

    public SeasonalMobsHandler(JavaPlugin javaPlugin) {
        super("mobs", javaPlugin);
        this.load();
        this.registerListener(this);
    }

    private void load() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SeasonType seasonType : SeasonType.values()) {
            builder.put((Object)seasonType, (Object)new SeasonMobs(seasonType, this.getConfig()));
        }
        this.seasonMobs = builder.build();
    }

    public EntityType getMob(Biome biome, SeasonType seasonType, boolean bl) {
        SeasonMobs seasonMobs = (SeasonMobs)this.seasonMobs.get((Object)seasonType);
        if (seasonMobs == null) {
            return null;
        }
        AdvancedBiomeBase advancedBiomeBase = Core.getBiomesHandler().getBiome(biome);
        String string = advancedBiomeBase == null ? biome.name() : advancedBiomeBase.getName();
        List list = Optional.ofNullable((List)seasonMobs.getBiomeMobs().get((Object)string)).orElse((List)seasonMobs.getBiomeMobs().get((Object)"ALL"));
        if (list == null) {
            return null;
        }
        if ((list = list.stream().filter(object -> ASManager.isHostile(EntityType.fromName((String)((String)object))) == bl).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        EntityType entityType = EntityType.valueOf((String)((String)list.get(ThreadLocalRandom.current().nextInt(list.size()))));
        return entityType;
    }

    @EventHandler
    public void onMobSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        if (!Core.getWorldHandler().isWorldEnabled(livingEntity.getWorld().getName())) {
            return;
        }
        if (!creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.NATURAL)) {
            return;
        }
        Location location = livingEntity.getLocation().clone();
        if (location.getBlock().isLiquid()) {
            return;
        }
        if (!ASManager.doChancesPass(this.spawnChance)) {
            return;
        }
        EntityType entityType = this.getMob(livingEntity.getLocation().getBlock().getBiome(), Core.getSeasonHandler().getSeason(livingEntity.getWorld()).getType(), livingEntity instanceof Monster);
        if (entityType == null) {
            return;
        }
        location.add(1.0, 0.0, 0.0);
        location.getWorld().spawnEntity(location, entityType, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }
}

