/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.handlers;

import com.google.common.collect.ImmutableMap;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.DataHandler;
import net.advancedplugins.seasons.Core;
import net.advancedplugins.seasons.enums.SeasonType;
import net.advancedplugins.seasons.listeners.WeatherListener;
import net.advancedplugins.seasons.objects.CustomWeatherType;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WeatherHandler
extends DataHandler {
    private final ImmutableMap<SeasonType, Integer> rainChance = ASManager.configToImmutableMap(this.getConfig(), "chanceOfPrecipitation", SeasonType::valueOf, Integer.class);

    public WeatherHandler(JavaPlugin javaPlugin) {
        super("weather", javaPlugin);
        this.registerListener(new WeatherListener());
        this.startWeatherTask();
    }

    private void startWeatherTask() {
        this.addTask(new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    if (!Core.getWorldHandler().isWorldEnabled(world.getName())) continue;
                    world.setStorm(ASManager.doChancesPass((Integer)WeatherHandler.this.rainChance.get((Object)Core.getSeasonHandler().getSeason(world).getType())));
                }
            }
        }.runTaskTimer((Plugin)Core.getInstance(), 20L, 400L).getTaskId());
    }

    public CustomWeatherType getWeather(String string) {
        SeasonType seasonType = Core.getSeasonHandler().getSeason(string).getType();
        World world = Bukkit.getWorld((String)string);
        Core cfr_ignored_0 = (Core)ASManager.getInstance();
        if (!Core.Bukkit) {
            return CustomWeatherType.SNOW;
        }
        if (world.hasStorm()) {
            if (seasonType.equals((Object)SeasonType.WINTER)) {
                return CustomWeatherType.SNOW;
            }
            return CustomWeatherType.RAIN;
        }
        if (ASManager.isDay(world.getTime())) {
            return CustomWeatherType.SUN;
        }
        return CustomWeatherType.MOON;
    }

    public ImmutableMap<SeasonType, Integer> getRainChance() {
        return this.rainChance;
    }
}

