/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.visuals.type;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.advancedplugins.seasons.enums.SeasonType;
import net.advancedplugins.seasons.visuals.type.IVisualType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class FallingLeafVisual
implements IVisualType {
    private final ConcurrentLinkedQueue<UUID> players = new ConcurrentLinkedQueue();
    private boolean enabled = true;
    private final Random random = new Random();

    @Override
    public void tick() {
        for (UUID uUID : this.players) {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player == null || !player.isOnline()) continue;
            this.createFallingLeaves(player, player.getLocation());
        }
        this.players.clear();
    }

    @Override
    public void tickSync() {
    }

    @Override
    public SeasonType getType() {
        return SeasonType.FALL;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void activate(Player player) {
        this.players.add(player.getUniqueId());
    }

    public void createFallingLeaves(Player player, Location location) {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        World world = location.getWorld();
        int n = location.getBlockX() - 4;
        int n2 = location.getBlockY() - 4;
        int n3 = location.getBlockZ() - 4;
        for (int i = n; i <= n + 8; ++i) {
            for (int j = n2; j <= n2 + 8; ++j) {
                for (int k = n3; k <= n3 + 8; ++k) {
                    Block block;
                    Block block2 = world.getBlockAt(i, j, k);
                    if (!block2.getType().name().endsWith("_LEAVES") || (block = world.getBlockAt(i, j - 1, k)).getType() != Material.AIR) continue;
                    arrayList.add(block2);
                }
            }
        }
        if (!arrayList.isEmpty()) {
            Block block = (Block)arrayList.get(this.random.nextInt(arrayList.size()));
            Location location2 = block.getLocation().add(0.5, 0.0, 0.5);
            player.spawnParticle(Particle.BLOCK_DUST, location2, 5, (Object)block.getBlockData());
        }
    }
}

