/*
 * Decompiled with CFR 0.152.
 */
package gcspawners;

import gcspawners.ASManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack a;

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.a = itemStack;
    }

    public ItemBuilder(Material material, int n) {
        this.a = new ItemStack(material, n);
    }

    public ItemBuilder(Material material, int n, byte by) {
        this.a = new ItemStack(material, n, (short)by);
    }

    public ItemBuilder clone() {
        return new ItemBuilder(this.a);
    }

    public ItemBuilder setDurability(int n) {
        this.a.setDurability((short)((byte)n));
        return this;
    }

    public ItemBuilder setName(String string) {
        ItemMeta itemMeta = this.a.getItemMeta();
        itemMeta.setDisplayName(string);
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        this.a.addUnsafeEnchantment(enchantment, n);
        return this;
    }

    public ItemBuilder hideEnchants() {
        ItemMeta itemMeta = this.a.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.a.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder setSkullOwner(String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.a.getItemMeta();
            skullMeta.setOwner(string);
            this.a.setItemMeta((ItemMeta)skullMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchantment, int n) {
        ItemMeta itemMeta = this.a.getItemMeta();
        itemMeta.addEnchant(enchantment, n, true);
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> map) {
        this.a.addEnchantments(map);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        this.a.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilder setLore(String ... stringArray) {
        ItemMeta itemMeta = this.a.getItemMeta();
        itemMeta.setLore(Arrays.asList(stringArray));
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        ItemMeta itemMeta = this.a.getItemMeta();
        itemMeta.setLore(list);
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(String string) {
        ItemMeta itemMeta = this.a.getItemMeta();
        ArrayList arrayList = new ArrayList(itemMeta.getLore());
        if (!arrayList.contains(string)) {
            return this;
        }
        arrayList.remove(string);
        itemMeta.setLore(arrayList);
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(int n) {
        ArrayList arrayList;
        ItemMeta itemMeta;
        block4: {
            itemMeta = this.a.getItemMeta();
            arrayList = new ArrayList(itemMeta.getLore());
            if (n >= 0 && n <= arrayList.size()) break block4;
            return this;
        }
        arrayList.remove(n);
        itemMeta.setLore(arrayList);
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        ItemMeta itemMeta = this.a.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (itemMeta.hasLore()) {
            arrayList = new ArrayList(itemMeta.getLore());
        }
        arrayList.add(string);
        itemMeta.setLore(arrayList);
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addLoreLine(String string, int n) {
        ItemMeta itemMeta = this.a.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>(itemMeta.getLore());
        arrayList.set(n, string);
        itemMeta.setLore(arrayList);
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLeatherArmorColor(Color color) {
        try {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.a.getItemMeta();
            leatherArmorMeta.setColor(color);
            this.a.setItemMeta((ItemMeta)leatherArmorMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemStack toItemStack() {
        return this.a;
    }

    public ItemBuilder setGlow(boolean bl) {
        if (!bl) {
            return this;
        }
        ItemMeta itemMeta = this.a.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemMeta.addEnchant(Enchantment.DAMAGE_UNDEAD, 1, true);
        this.a.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setAmount(int n) {
        this.a.setAmount(n);
        return this;
    }

    public ItemBuilder addAllItemFlags() {
        block4: {
            ItemMeta itemMeta = this.a.getItemMeta();
            ItemFlag[] itemFlagArray = ItemFlag.values();
            boolean bl = ASManager.c;
            for (ItemFlag itemFlag : itemFlagArray) {
                itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
                if (!bl) {
                    if (!bl) continue;
                    break;
                }
                break block4;
            }
            this.a.setItemMeta(itemMeta);
        }
        return this;
    }
}

